@extends('/CRM/layout')

@section('script')

@endsection
@section('head')

@endsection
@section('content')
    <div class="portlet light bordered main">
        @include('CRM.Admin.section.errors')
    </div>
    <div class="col-md-12 ">
        <!-- BEGIN SAMPLE FORM PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption">
                    <i class="fa fa-image"></i>
                    <span class="caption-subject font-dark sbold uppercase">لوگو همکاران</span>
                </div>
            </div>
            <div class="portlet-body form">
                @php($width=100)
                @php($heigt=100)
                <form class="form-horizontal" method="POST" action="{{route('service.store')}}"
                      enctype='multipart/form-data' role="form">
                    {{csrf_field()}}
                    <input type="hidden" name="width" value="{{$width}}">
                    <input type="hidden" name="heigt" value="{{$heigt}}">

                    <div class="form-body">
                        <div class="form-group ">
                            <label class="col-md-2 control-label">عنوان</label>
                            <div class="col-md-10">
                                <input name="title" type="text" value="{{old('title')}}"
                                       class="form-control" required placeholder="عنوان">
                            </div>
                        </div>
                        <div class="form-group ">
                            <label class="col-md-2 control-label">Url</label>
                            <div class="col-md-10">
                                <div class="input-group">
                                    <span class="input-group-addon"><i class="fa fa-link"></i></span>
                                    <input name="url" type="url" value="{{old('url')}}"
                                           class="form-control" required
                                           placeholder="Url Address">
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="col-md-2 control-label">ترتیب</label>
                            <div class="col-md-1">
                                <input name="order" type="number" min="1" class="form-control" required
                                       @if(old('order')) value="{{old('order')}}" @else value="1" @endif
                                       placeholder="1">
                            </div>
                        </div>
                        <div class="form-group">
                            <div class="bgColor">
                                <div style="width: {{$width}}px;height: {{$heigt}}px" class="targetOuter">
                                    <div id="target1" class="targetLayer">

                                    </div>
                                    <img src="{{asset('CRM_Assets/assets/pages/img/easy.png')}}"
                                         class="icon-choose-image"/>

                                    <div class="icon-choose-image">
                                        <input name="image" title="انتخاب عکس" type="file"
                                               class="inputFile userImage"
                                               required
                                               onChange="showPreview(this,'#target1','{{$width}}px','{{$heigt}}px');"/>
                                    </div>
                                </div>
                                <label class="col-sm-4 control-label">سایز مناسب عکس {{$width}}x{{$heigt}} پیکسل</label>

                                <div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="form-actions">
                        <button type="submit" class="btn green">ثبت</button>
                    </div>
                </form>

            </div>
        </div>
        <!-- END SAMPLE FORM PORTLET-->
        <div class="col-md-12">
            <div class="panel panel-default">

                <div class="panel-heading">
                    <h3 class="panel-title FarsiFont "><i class="fa fa-list"></i>&nbsp;لیست لینکهال</h3>
                </div>

                <div class="panel-body">
                    <div class="table">
                        <table class="table table-striped table-bordered table-hover order-column dataTable no-footer"
                               id="sample_1" role="grid" aria-describedby="sample_1_info">
                            <thead>
                            <tr role="row">
                                <th class="sorting_disable text-center" style="width: 10px;" aria-label=""><i
                                            class="fa fa-gears"></i></th>
                                <th class="sorting_desc text-center" tabindex="0" aria-controls="sample_1" rowspan="1"
                                    colspan="1" aria-label=""> زمان ایجاد
                                </th>

                                <th class="sorting_disable text-center" tabindex="0" aria-controls="sample_1"
                                    rowspan="1"
                                    colspan="1" aria-label="ترتیب">ترتیب
                                </th>
                                <th class="sorting_disable text-center" tabindex="0" aria-controls="sample_1"
                                    rowspan="1"
                                    colspan="1" aria-label="عنوان">عنوان
                                </th>

                                <th class="sorting_disable text-center" style="width: 60px" aria-sort="descending"
                                    tabindex="0"
                                    aria-controls="sample_1" rowspan="1" colspan="1">لینک
                                </th>
                                <th class="sorting_disable text-center" aria-sort="descending"
                                    aria-controls="sample_1" rowspan="1" colspan="1">عکس
                                </th>

                            </tr>
                            </thead>
                            <tbody>
                            @foreach($services as $service)
                                <tr role="row" class="">

                                    <td>
                                        <div class="btn-group">
                                            <button class="btn btn-xs btn-danger dropdown-toggle bold" type="button"
                                                    data-toggle="dropdown" aria-expanded="false">
                                                <i class="fa fa-gears"></i>
                                                <i class="fa fa-angle-down"></i>
                                            </button>
                                            <ul class="dropdown-menu" role="menu">
                                                <li>
                                                    <a href="{{route('service.edit',$service->id)}}">
                                                        <i class="fa fa-file-text" style="color:#5E6EDD "></i> ویرایش
                                                    </a>
                                                </li>

                                                <li>
                                                    <form class="form-horizontal" method="POST"
                                                          action="{{route('service.destroy',$service->id)}}"
                                                          role="form">
                                                        {{method_field('DELETE')}}
                                                        {{csrf_field()}}
                                                        <button style="text-align: right;background: none;border: none"
                                                                type="submit" class="text-danger col-md-12 text-right">
                                                            <i class="fa fa-minus-circle" style="color:#ED6B75 "></i>
                                                            حذف
                                                        </button>
                                                    </form>
                                                </li>

                                            </ul>
                                        </div>
                                    </td>

                                    <td style="width: 200px"
                                        class="text-center">{{convert(jDate::forge($service->created_at)->format('datetime'))}}</td>
                                    <td style="width: 100px" class="text-center">{{$service->order}}</td>
                                    <td  class="text-center">{{$service->title}}</td>

                                    <td class="text-center">
                                        {{$service->url}}
                                    </td>
                                    <td class="text-center">
                                        <img style="max-width: 105px" alt="{{$service->name}}"
                                             src="{{url($service->image_path)}}">
                                    </td>


                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

    </div>
@endsection
@section('footer')
    @if (alert()->ready())
        <script>
            $(document).ready(function () {
                swal({
                    title: "{!! alert()->message() !!}",
                    text: "{!! alert()->option('text') !!}",
                    type: "{!! alert()->type() !!}",
                    @if(alert()->option('timer'))
                    timer: "{!! alert()->option('timer') !!}",
                    showConfirmButton: false,
                    @endif
                });
            })
        </script>
    @endif
    <script>
        function showPreview(objFileInput, id, w, h) {
            if (objFileInput.files[0]) {
                var fileReader = new FileReader();
                fileReader.onload = function (e) {
                    $('#blah').attr('src', e.target.result);
                    $(id).html('<img src="' + e.target.result + '" width=" ' + w + ' "; height="' + h + '" class="upload-preview" />');
                    $(".targetLayer").css('opacity', '0.7');
                    $(".icon-choose-image").css('opacity', '0.5');
                };
                fileReader.readAsDataURL(objFileInput.files[0]);
            }
        }
    </script>

@endsection