@extends('/CRM/layout')

@section('script')

@endsection
@section('head')

@endsection
@section('content')
    <div class="portlet light bordered main">
        @include('CRM.Admin.section.errors')
    </div>
    <div class="col-md-12 ">
        <!-- BEGIN SAMPLE FORM PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption">
                    <i class="fa fa-image"></i>
                    <span class="caption-subject font-dark sbold uppercase">لوگو همکاران</span>
                </div>
            </div>
            <div class="portlet-body form">
                @php($width=100)
                @php($heigt=100)
                <form class="form-horizontal" method="POST" action="{{route('service.update',$service->id)}}"
                      enctype='multipart/form-data' role="form">
                    {{method_field('PUT')}}
                    {{csrf_field()}}
                    <input type="hidden" name="width" value="{{$width}}">
                    <input type="hidden" name="heigt" value="{{$heigt}}">

                    <div class="form-body">
                        <div class="form-group ">
                            <label class="col-md-2 control-label">عنوان</label>
                            <div class="col-md-10">
                                <input name="title" type="text" value="{{$service->title}}"
                                       class="form-control" required placeholder="عنوان">
                            </div>
                        </div>
                        <div class="form-group ">
                            <label class="col-md-2 control-label">Url</label>
                            <div class="col-md-10">
                                <div class="input-group">
                                    <span class="input-group-addon"><i class="fa fa-link"></i></span>
                                    <input name="url" type="url" value="{{$service->url}}"
                                           class="form-control d-ltr" required
                                           placeholder="Url Address">
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="col-md-2 control-label">ترتیب</label>
                            <div class="col-md-1">
                                <input name="order" type="number" min="1" class="form-control" required
                                       value="{{$service->order}}"
                                       placeholder="1">
                            </div>
                        </div>
                        <div class="form-group">
                            <div class="bgColor">
                                <div style="width: {{$width}}px;height: {{$heigt}}px" class="targetOuter">
                                    <div id="target1" class="targetLayer">
                                        @isset($service)
                                            <img src="{{$service->image_path}}" width="{{$width}}px"
                                                 height="{{$heigt}}px" class="upload-preview"/>
                                        @endisset

                                    </div>
                                    <img src="{{asset('CRM_Assets/assets/pages/img/easy.png')}}"
                                         class="icon-choose-image"/>

                                    <div class="icon-choose-image">
                                        <input name="image" title="انتخاب عکس" type="file"
                                               class="inputFile userImage"
                                               onChange="showPreview(this,'#target1','{{$width}}px','{{$heigt}}px');"/>
                                    </div>
                                </div>
                                <label class="col-sm-4 control-label">سایز مناسب عکس {{$width}}x{{$heigt}} پیکسل</label>

                                <div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="form-actions">
                        <button type="submit" class="btn green">ویرایش</button>
                    </div>
                </form>

            </div>
        </div>
        <!-- END SAMPLE FORM PORTLET-->

    </div>
@endsection
@section('footer')

    <script>
        function showPreview(objFileInput, id, w, h) {
            if (objFileInput.files[0]) {
                var fileReader = new FileReader();
                fileReader.onload = function (e) {
                    $('#blah').attr('src', e.target.result);
                    $(id).html('<img src="' + e.target.result + '" width=" ' + w + ' "; height="' + h + '" class="upload-preview" />');
                    $(".targetLayer").css('opacity', '0.7');
                    $(".icon-choose-image").css('opacity', '0.5');
                };
                fileReader.readAsDataURL(objFileInput.files[0]);
            }
        }
    </script>

@endsection