@extends('/CRM/layout')

@section('script')
    <script src="/CRM_Assets/assets/fontawesome-iconpicker/js/fontawesome-iconpicker.min.js"></script>
    <script src="/CRM_Assets/assets/global/plugins/select2/js/select2.full.min.js" type="text/javascript"></script>
@endsection
@section('head')
    <link rel="stylesheet" href="/CRM_Assets/assets/fontawesome-iconpicker/css/fontawesome-iconpicker.min.css">
    <link rel="stylesheet" href="/CRM_Assets/assets/font-awesome-4.7.0/css/font-awesome.min.css">
    <link href="/CRM_Assets/assets/global/plugins/select2/css/select2.min.css" rel="stylesheet" type="text/css"/>
    <link href="/CRM_Assets/assets/global/plugins/select2/css/select2-bootstrap.min.css" rel="stylesheet" type="text/css"/>
@endsection
@section('content')
    <div class="portlet light bordered main">
        @include('CRM.Admin.section.errors')
    </div>
    <div class="col-md-12 ">
        <!-- BEGIN SAMPLE FORM PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption">
                    <i class="fa fa-image"></i>
                    <span class="caption-subject font-dark sbold uppercase">قیمت لحظه ای</span>
                </div>
            </div>
            <div class="portlet-body form">


                <form class="form-horizontal" method="POST" action="{{route('priceList.store')}}"
                      enctype='multipart/form-data' role="form">
                    {{csrf_field()}}

                    <div class="form-body">
                        <div class="form-group ">
                            <label class="col-md-2 control-label">عنوان</label>
                            <div class="col-md-10">
                                <input name="title" type="text" value="{{old('title')}}"
                                       class="form-control" required placeholder="عنوان">
                            </div>
                        </div>

                        <div class="form-group">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label class="control-label col-md-2">محصول
                                        <span class="required"> * </span>
                                    </label>
                                    <div class="col-md-10">
                                        <select required class="form-control select2me" name="product_id">
                                            <option value="">جست و جو با نام..</option>
                                            @foreach($products as $product)
                                                <option value="{{$product->id}}">{{$product->id}}
                                                    : {{$product->name}}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>

                    <div class="form-actions">
                        <button type="submit" class="btn green">ثبت</button>
                    </div>
                </form>

            </div>
        </div>
        <!-- END SAMPLE FORM PORTLET-->
        <div class="col-md-12">
            <div class="panel panel-default">

                <div class="panel-heading">
                    <h3 class="panel-title FarsiFont "><i class="fa fa-list"></i>&nbsp;لیست قیمتها</h3>
                </div>

                <div class="panel-body">
                    <div class="table">
                        <table class="table table-striped table-bordered table-hover order-column dataTable no-footer"
                               id="sample_1" role="grid" aria-describedby="sample_1_info">
                            <thead>
                            <tr role="row">
                                <th class="sorting_disable text-center" style="width: 10px;" aria-label=""><i
                                            class="fa fa-gears"></i></th>
                                <th class="sorting_desc text-center" tabindex="0" aria-controls="sample_1" rowspan="1"
                                    colspan="1" aria-label=""> زمان ایجاد
                                </th>

                                <th class="sorting_disable text-center" tabindex="0" aria-controls="sample_1"
                                    rowspan="1"
                                    colspan="1" aria-label="عنوان">عنوان
                                </th>

                                <th class="sorting_disable text-center" style="width: 60px" aria-sort="descending"
                                    tabindex="0"
                                    aria-controls="sample_1" rowspan="1" colspan="1">محصول
                                </th>

                            </tr>
                            </thead>
                            <tbody>
                            @foreach($priceLists as $priceList)
                                <tr role="row" class="">

                                    <td>
                                        <div class="btn-group">
                                            <button class="btn btn-xs btn-danger dropdown-toggle bold" type="button"
                                                    data-toggle="dropdown" aria-expanded="false">
                                                <i class="fa fa-gears"></i>
                                                <i class="fa fa-angle-down"></i>
                                            </button>
                                            <ul class="dropdown-menu" role="menu">
                                                <li>
                                                    <a href="{{route('priceList.edit',$priceList->id)}}">
                                                        <i class="fa fa-file-text" style="color:#5E6EDD "></i> ویرایش
                                                    </a>
                                                </li>

                                                <li>
                                                    <form class="form-horizontal" method="POST"
                                                          action="{{route('priceList.destroy',$priceList->id)}}" role="form">
                                                        {{method_field('DELETE')}}
                                                        {{csrf_field()}}
                                                        <button style="text-align: right;background: none;border: none"
                                                                type="submit" class="text-danger col-md-12 text-right">
                                                            <i class="fa fa-minus-circle" style="color:#ED6B75 "></i>
                                                            حذف
                                                        </button>
                                                    </form>
                                                </li>

                                            </ul>
                                        </div>
                                    </td>

                                    <td style="width: 200px"
                                        class="text-center">{{convert(jDate::forge($priceList->created_at)->format('datetime'))}}</td>
                                    <td style="width: 400px"
                                        class="text-center">{{$priceList->title}}</td>

                                    <td class="text-center">
                                        {{$priceList->product->name}}
                                    </td>


                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

    </div>
@endsection
@section('footer')
    @if (alert()->ready())
        <script>
            $(document).ready(function () {
                swal({
                    title: "{!! alert()->message() !!}",
                    text: "{!! alert()->option('text') !!}",
                    type: "{!! alert()->type() !!}",
                    @if(alert()->option('timer'))
                    timer: "{!! alert()->option('timer') !!}",
                    showConfirmButton: false,
                    @endif
                });
            })
        </script>
    @endif

@endsection