@extends('/CRM/layout')

@section('script')
    <script src="/CRM_Assets/assets/fontawesome-iconpicker/js/fontawesome-iconpicker.min.js"></script>
    <script src="/CRM_Assets/assets/global/plugins/select2/js/select2.full.min.js" type="text/javascript"></script>
@endsection
@section('head')
    <link rel="stylesheet" href="/CRM_Assets/assets/fontawesome-iconpicker/css/fontawesome-iconpicker.min.css">
    <link rel="stylesheet" href="/CRM_Assets/assets/font-awesome-4.7.0/css/font-awesome.min.css">
    <link href="/CRM_Assets/assets/global/plugins/select2/css/select2.min.css" rel="stylesheet" type="text/css"/>
    <link href="/CRM_Assets/assets/global/plugins/select2/css/select2-bootstrap.min.css" rel="stylesheet"
          type="text/css"/>
@endsection
@section('content')
    <div class="portlet light bordered main">
        @include('CRM.Admin.section.errors')
    </div>
    <div class="col-md-12 ">
        <!-- BEGIN SAMPLE FORM PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption">
                    <i class="fa fa-image"></i>
                    <span class="caption-subject font-dark sbold uppercase">قیمت لحظه ای</span>
                </div>
            </div>
            <div class="portlet-body form">


                <form class="form-horizontal" method="POST" action="{{route('priceList.update',$priceList->id)}}"
                      enctype='multipart/form-data' role="form">
                    {{method_field('PATCH')}}
                    {{csrf_field()}}

                    <div class="form-body">
                        <div class="form-group ">
                            <label class="col-md-2 control-label">عنوان</label>
                            <div class="col-md-10">
                                <input name="title" type="text" value="{{$priceList->title}}"
                                       class="form-control" required placeholder="عنوان">
                            </div>
                        </div>

                        <div class="form-group">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label class="control-label col-md-2">محصول
                                        <span class="required"> * </span>
                                    </label>
                                    <div class="col-md-10">
                                        <select required class="form-control select2me" name="product_id">
                                            <option value="">جستوجو با نام..</option>
                                            @foreach($products as $product)
                                                <option {{$priceList->product_id == $priceList->product->id ?'selected' :''}} value="{{$product->id}}">{{$product->id}}
                                                    : {{$product->name}}</option>
                                            @endforeach>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>

                    <div class="form-actions">
                        <button type="submit" class="btn green">ویرایش</button>
                    </div>
                </form>

            </div>
        </div>
        <!-- END SAMPLE FORM PORTLET-->

    </div>
@endsection
@section('footer')
    @if (alert()->ready())
        <script>
            $(document).ready(function () {
                swal({
                    title: "{!! alert()->message() !!}",
                    text: "{!! alert()->option('text') !!}",
                    type: "{!! alert()->type() !!}",
                    @if(alert()->option('timer'))
                    timer: "{!! alert()->option('timer') !!}",
                    showConfirmButton: false,
                    @endif
                });
            })
        </script>
    @endif

@endsection