@extends('/CRM/layout')

@section('script')
    <!-- BEGIN PAGE LEVEL PLUGINS -->
    <script src="/CRM_Assets/assets/global/scripts/datatable.js" type="text/javascript"></script>
    <script src="/CRM_Assets/assets/global/plugins/datatables/datatables.min.js" type="text/javascript"></script>
    <script src="/CRM_Assets/assets/global/plugins/datatables/plugins/bootstrap/datatables.bootstrap.js"
            type="text/javascript"></script>
    <!-- END PAGE LEVEL PLUGINS -->
    <!-- BEGIN PAGE LEVEL SCRIPTS -->
    <script src="/CRM_Assets/assets/pages/scripts/table-datatables-managed.min.js" type="text/javascript"></script>
    <!-- END PAGE LEVEL SCRIPTS -->


    <script>
        $(document).ready(function () {
            $('#permission_id').selectpicker();
        })
    </script>
@endsection
@php
    $newestItems = new \App\Models\NewestItem();
@endphp
@section('content')
    <div class="portlet light bordered main">
        @include('CRM.Admin.section.errors')
    </div>

    <div class="col-md-12">
        <div class="panel panel-default">

            <div class="panel-heading">
                <h3 class="panel-title FarsiFont "><i class="fa fa-list"></i>&nbsp;مدیریت صفحات</h3>
            </div>
            @if(Auth::user()->can(['همه','صفحات','ثبت صفحه جدید']))
            <div class="panel-heading">
                <h3 class="panel-title FarsiFont">
                    <a class="btn btn-success text-white" href="{{route('page.create')}}">ثبت صفحه جدید</a>
                </h3>
            </div>
            @endif
            <div class="panel-body">
                <div class="table">
                    <table class="table table-striped table-bordered table-hover order-column dataTable no-footer"
                           id="sample_1" role="grid" aria-describedby="sample_1_info">
                        <thead>
                        <tr role="row">
                            <th class="sorting_disable text-center" style="width: 10px;" aria-label=""><i
                                        class="fa fa-gears"></i></th>
                            <th class="sorting_desc text-center" tabindex="0" aria-controls="sample_1" rowspan="1"
                                colspan="1" aria-label=""> زمان ایجاد
                            </th>

                            <th class="sorting_disable text-center" tabindex="0" aria-controls="sample_1" rowspan="1"
                                colspan="1" aria-label="عنوان">عنوان
                            </th>
                            <th class="sorting_disable text-center" style="" aria-sort="descending" tabindex="0"
                                aria-controls="sample_1" rowspan="1"
                                colspan="1" aria-label="ادرس">ادرس
                            </th>

                        </tr>
                        </thead>
                        <tbody>
                        @foreach($pages as $page)
                            <tr role="row">

                                <td>
                                    <div class="btn-group">
                                        <button class="btn btn-xs btn-danger dropdown-toggle bold" type="button"
                                                data-toggle="dropdown" aria-expanded="false">
                                            <i class="fa fa-gears"></i>
                                            <i class="fa fa-angle-down"></i>
                                        </button>
                                        <ul class="dropdown-menu" role="menu">
                                            <li>
                                                <a href="{{route('page.edit',$page->id)}}">
                                                    <i class="fa fa-file-text" style="color:#5E6EDD "></i> ویرایش </a>
                                            </li>
                                            <li>
                                                <form class="form-horizontal" method="POST" action="{{route('page.destroy',$page->id)}}" role="form">
                                                    {{method_field('DELETE')}}
                                                    {{csrf_field()}}
                                                    <button style="text-align: right;background: none;border: none" type="submit" class="text-danger col-md-12 text-right">
                                                        <i class="fa fa-minus-circle" style="color:#ED6B75 "></i> حذف
                                                    </button>
                                                </form>
                                            </li>

                                        </ul>
                                    </div>
                                </td>
                                <td style="width: 90px" class="text-center">
                                    {{convert(jDate::forge($page->created_at)->format('datetime'))}}
                                </td>

                                <td style="text-decoration: none;font-weight: bold;"
                                    class="text-center">{{$page->title}}</td>
                                <td class="text-center d-ltr">
                                    {{url($page->path())}}
                                </td>



                            </tr>
                        @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>




@endsection
@section('head')
    <!-- BEGIN PAGE LEVEL PLUGINS -->
    <link href="/CRM_Assets/assets/global/plugins/datatables/datatables.min.css" rel="stylesheet" type="text/css"/>
    <link href="/CRM_Assets/assets/global/plugins/datatables/plugins/bootstrap/datatables.bootstrap-rtl.css"
          rel="stylesheet" type="text/css"/>

    <!-- END PAGE LEVEL PLUGINS -->

    @if (alert()->ready())
        <script>
            $(document).ready(function () {
                swal({
                    title: "{!! alert()->message() !!}",
                    text: "{!! alert()->option('text') !!}",
                    type: "{!! alert()->type() !!}",
                    @if(alert()->option('timer'))
                    timer: "{!! alert()->option('timer') !!}",
                    showConfirmButton: false,
                    @endif
                });
            })
        </script>
    @endif


    <script>

        function showPreview(objFileInput, id, w, h) {
            if (objFileInput.files[0]) {
                var fileReader = new FileReader();
                fileReader.onload = function (e) {
                    $('#blah').attr('src', e.target.result);
                    $(id).html('<img src="' + e.target.result + '" width=" ' + w + ' "; height="' + h + '" class="upload-preview" />');
                    $(".targetLayer").css('opacity', '0.7');
                    $(".icon-choose-image").css('opacity', '0.5');
                };
                fileReader.readAsDataURL(objFileInput.files[0]);
            }
        }
    </script>
@endsection
