@extends('/CRM/layout')

@section('script')
    <!-- BEGIN PAGE LEVEL PLUGINS -->
    <script src="/CRM_Assets/assets/global/scripts/datatable.js" type="text/javascript"></script>
    <script src="/CRM_Assets/assets/global/plugins/datatables/datatables.min.js" type="text/javascript"></script>
    <script src="/CRM_Assets/assets/global/plugins/datatables/plugins/bootstrap/datatables.bootstrap.js"
            type="text/javascript"></script>
    <!-- END PAGE LEVEL PLUGINS -->
    <!-- BEGIN PAGE LEVEL SCRIPTS -->
    <script src="/CRM_Assets/assets/pages/scripts/table-datatables-managed.min.js" type="text/javascript"></script>
    <!-- END PAGE LEVEL SCRIPTS -->
    <!-- bootstrap-tagsinput -->
    <script src="/CRM_Assets/assets/global/plugins/bootstrap-tagsinput/bootstrap-tagsinput.min.js"
            type="text/javascript"></script>
    <!-- bootstrap-tagsinput -->
    <script src="/CRM_Assets/ckeditor/ckeditor.js" type="text/javascript"></script>
    <script>

        var options = {
            filebrowserImageBrowseUrl: '/laravel-filemanager?type=Images',
            filebrowserImageUploadUrl: '/laravel-filemanager/upload?type=Images&_token=',
            filebrowserBrowseUrl: '/laravel-filemanager?type=Files',
            filebrowserUploadUrl: '/laravel-filemanager/upload?type=Files&_token='
        };
        CKEDITOR.replace('body', options);

    </script>

@endsection
@php
    $newestItems = new \App\Models\NewestItem();
@endphp
@section('content')
    <div class="portlet light bordered main">
        @include('CRM.Admin.section.errors')
    </div>
    <div class="col-md-12 ">
        <div class="portlet light bordered">
            <div class="portlet-body form">

                <form class="form-horizontal" method="POST" action="{{route('page.update',$page->id)}}"
                      enctype='multipart/form-data' role="form">
                    {{method_field('PATCH')}}
                    {{csrf_field()}}

                    <div class="form-body">
                        <div class="form-group">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label class="col-md-2 control-label">عنوان</label>
                                    <div class="col-md-10">
                                        <input name="title" type="text" class="form-control" required
                                               value="{{$page->title}}"
                                               placeholder="عنوان">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label class="col-md-2 control-label">متن مقاله</label>
                                    <div class="col-md-10">
                                        <textarea name="body">{!! $page->body !!}</textarea>
                                    </div>
                                </div>
                            </div>
                        </div>


                    </div>
                    <div class="form-actions">
                        <button type="submit" class="btn green">ویرایش</button>
                        <a class="btn red" href="{{route('page.index')}}">انصراف</a>
                    </div>
                </form>
            </div>
        </div>
    </div>



@endsection
@section('head')
    <!-- BEGIN PAGE LEVEL PLUGINS -->
    <link href="/CRM_Assets/assets/global/plugins/datatables/datatables.min.css" rel="stylesheet" type="text/css"/>
    <link href="/CRM_Assets/assets/global/plugins/datatables/plugins/bootstrap/datatables.bootstrap-rtl.css"
          rel="stylesheet" type="text/css"/>
    <link href="/CRM_Assets/assets/global/plugins/bootstrap-tagsinput/bootstrap-tagsinput.css"
          rel="stylesheet" type="text/css"/>

    <!-- END PAGE LEVEL PLUGINS -->

    @if (alert()->ready())
        <script>
            $(document).ready(function () {
                swal({
                    title: "{!! alert()->message() !!}",
                    text: "{!! alert()->option('text') !!}",
                    type: "{!! alert()->type() !!}",
                    @if(alert()->option('timer'))
                    timer: "{!! alert()->option('timer') !!}",
                    showConfirmButton: false,
                    @endif
                });
            })
        </script>
    @endif

    <script>

        function showPreview(objFileInput, id, w, h) {
            if (objFileInput.files[0]) {
                var fileReader = new FileReader();
                fileReader.onload = function (e) {
                    $('#blah').attr('src', e.target.result);
                    $(id).html('<img src="' + e.target.result + '" width=" ' + w + ' "; height="' + h + '" class="upload-preview" />');
                    $(".targetLayer").css('opacity', '0.7');
                    $(".icon-choose-image").css('opacity', '0.5');
                };
                fileReader.readAsDataURL(objFileInput.files[0]);
            }
        }
    </script>
@endsection
