@if(isset($order) && $mode != 0)
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">×</span>
        </button>
        <h4 class="modal-title" id="myModalLabel">سفارش شماره: {{convert($order->id)}}
        </h4>
        <div class="mt-comment-details">
            <div class="mt-comment-status mt-comment-status-pending">
                <div class="mt-action-buttons ">
                    <div class="btn-group pull-left">
                        <a href="{{route('admin.invoice.index',$order)}}" target="_blank" class="btn btn-outline blue-chambray" title="چاپ فاکتور"><span class="glyphicon glyphicon-print"></span></a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="modal-body">
        <div class="mt-comments">
            <div class="mt-comment">
                <div class="mt-comment-img">
                    <img src="/CRM_Assets/assets/layouts/layout/img/online_order_icon.png"> </div>
                <div class="mt-comment-body">
                    <div class="mt-comment-info">
                        <span class="mt-comment-author"></span>
                        <span class="mt-comment-date"></span>
                    </div>
                    <div class="mt-comment-text" style="line-height: 2">
                        <div id="primary-info">
                            <span>کاربر :  </span>
                            <b>{{$order->Address->User->fname}} {{$order->Address->User->lname}} - ({{$order->Address->User->mobile}})</b>
                            <span> / </span>
                            <span>جنسیت :  </span>
                            <b>{{$order->Cart->User->gender == 1? 'مرد':'زن'}} </b>
                            <br>
                            <span>سبد خرید شماره :  </span>
                            <b>{{$order->cart_id}}</b>
                            <br>
                            <span>شناسه واریز موفق : </span>
                            <b>{{$order->transaction_id}}</b>
                            <span> / </span>
                            <span>شناسه واریز بانک : </span>
                            <b>{{$order->Transaction->transaction_id}}</b>
                        </div>
                        <hr>
                        {{--------------------}}
                        <div id="address-info">
                            <span>استان :  </span>
                            <b>{{$order->Address->state}}</b>
                            <span> / </span>
                            <span>شهر :  </span>
                            <b>{{$order->Address->city}}</b>
                            <span> / </span>
                            <span>کد پستی :  </span>
                            <b>{{$order->Address->postal_code}}</b>
                            <br>
                            <span>شماره تلفن :  </span>
                            <b>{{$order->Address->tell}}</b>
                            <span> / </span>
                            <span>شماره تماس ضروری :  </span>
                            <b>{{$order->Address->urgent_phone_no}}</b>
                            <br>
                            <span>آدرس : </span>
                            <b>{{$order->Address->address}}</b>
                        </div>
                        <hr>
                        {{------------------------}}
                        <div id="paycheck-info">
                            <span>بهای تمام شده سبد خرید : </span>
                            <b>{{priceFormat($order->package_price)}}</b>
                            <span>تومان</span>
                            <span> / </span>
                            <span>هزینه پستی دریافت شده : </span>
                            <b>{{priceFormat($order->shipment_price)}}</b>
                            <span>تومان</span>
                            <br>
                            <span>کل : </span>
                            <b>{{priceFormat($order->total)}}</b>
                            <span>تومان</span>
                            <span> / </span>
                            <span>کد تخفیف : </span>
                            @if(!is_null($order->discount_code_id))
                                <b> شناسه {{$order->discount_code_id}}</b>
                                <span> / </span>
                                <span>میزان تخفیف : </span>
                                <b>{{priceFormat($order->discount)}}</b>
                                <span>تومان</span>
                            @else
                                <b>ندارد</b>
                            @endif
                            <br>
                            <span>مبلغ پرداخت شده : </span>
                            <b>{{priceFormat($order->payable_price)}}</b>
                            <span>تومان</span>
                        </div>
                        <hr>
                        @if($mode == 4 || $mode == 5)
                            <div id="post-info">
                                <span>نوع ارسال : </span>

                                @if($order->PostLog->type == 0)
                                    <b><i class="fa fa-gift" style="color:#ff2843; border: 1px solid #ff2843;border-radius: 50%;padding: 4px"></i> پستی </b>
                                    <span> / </span>
                                    <span>کد مرصوله : </span>
                                    <b>{{$order->PostLog->post_code}}</b>
                                @else
                                    <b> <i class="fa fa-motorcycle" style="color:#ff2843; border: 1px solid #ff2843;border-radius: 50%;padding: 4px"></i> پیک </b>
                                @endif
                                <span> / </span>
                                <span>هزینه ارسال واقعی: </span>
                                <b>{{priceFormat($order->PostLog->price)}}</b> تومان
                            </div>
                            <hr>
                        @endif
                        {{------------------------}}
                        <div id="product-info"></div>
                        <span>کالاهای این سفارش : </span>
                        <br>
                        <ul>
                            <div class="table-responsive" style="margin-right: -60px;">
                                <table class="table table-striped table-bordered">
                                    <thead>
                                    <tr>
                                        <th class="text-center"> کد کالا</th>
                                        <th class="text-center"> نام</th>
                                        <th class="text-center">تعداد</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @foreach($order->Cart->CartProduct()->get() as $cart_product)
                                        <tr>

                                            <td class="text-center">
                                                {{$cart_product->ProductColor->code}}
                                            </td>
                                            <td class="text-center">
                                                {{$cart_product->ProductColor->Product->name}}
                                            </td>
                                            <td class="text-center">
                                                {{$cart_product->qty}}
                                            </td>
                                        </tr>
                                    @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </ul>
                    </div>
                    <div class="mt-comment-details">
                        <div class="mt-comment-status mt-comment-status-pending">
                            <div class="mt-action-buttons ">
                                <div class="btn-group pull-right">
                                    @if($mode != 5)
                                        <button type="button" data-option="{{$order->Address->city}}" data-content="{{$order->id}}" data-title="{{$mode}}" class="btn btn-outline green btn-sm approve-order ">تایید و انتقال به مرحله بعد</button>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@else
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">×</span>
        </button>
        <h4 class="modal-title" id="myModalLabel">سفارش شماره: {{convert($order->id)}} (هنوز پرداخت نشده)
        </h4>
    </div>
    <div class="modal-body">
        <div class="mt-comments">
            <div class="mt-comment">
                <div class="mt-comment-img">
                    <img src="/CRM_Assets/assets/layouts/layout/img/online_order_icon.png"> </div>
                <div class="mt-comment-body">
                    <div class="mt-comment-info">
                        <span class="mt-comment-author"></span>
                        <span class="mt-comment-date"></span>
                    </div>
                    <div class="mt-comment-text" style="line-height: 2">
                        <span>کاربر :  </span>
                        <b>{{$order->Address->User->fname}} {{$order->Address->User->lname}} - ({{$order->Address->User->mobile}})</b>
                        <br>
                        <span>سبد خرید شماره :  </span>
                        <b>{{$order->cart_id}}</b>
                        <hr>
                        {{---------------------}}
                        <span>بهای تمام شده سبد خرید : </span>
                        <b>{{priceFormat($order->package_price)}}</b>
                        <span>تومان</span>
                        <span> / </span>
                        <span>هزینه پستی خرید : </span>
                        <b>{{priceFormat($order->shipment_price)}}</b>
                        <span>تومان</span>
                        <br>
                        <span>کل : </span>
                        <b>{{priceFormat($order->total)}}</b>
                        <span>تومان</span>
                        <span> / </span>
                        <span>کد تخفیف : </span>
                        @if(!is_null($order->discount_code_id))
                            <b> شناسه {{$order->discount_code_id}}</b>
                            <span> / </span>
                            <span>میزان تخفیف : </span>
                            <b>{{priceFormat($order->discount)}}</b>
                            <span>تومان</span>
                        @else
                            <b>ندارد</b>
                        @endif
                        <br>
                        <span>مبلغ قابل پرداخت : </span>
                        <b>{{priceFormat($order->payable_price)}}</b>
                        <span>تومان</span>
                        <hr>
                        <span>کالاهای این سفارش : </span>
                        <br>
                        <ul>
                            <div class="table-responsive" style="margin-right: -60px;">
                                <table class="table table-striped table-bordered">
                                    <thead>
                                    <tr>
                                        <th class="text-center"> کد کالا</th>
                                        <th class="text-center">نام</th>
                                        <th class="text-center">تعداد</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @foreach($order->Cart->CartProduct()->get() as $cart_product)
                                        <tr>
                                            <td class="text-center">{{$cart_product->ProductColor->code}} </td>
                                            <td class="text-center">{{$cart_product->ProductColor->Product->name}}</td>
                                            <td class="text-center">
                                                {{$cart_product->qty}}
                                            </td>
                                        </tr>
                                    @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endif
