@extends('/CRM/layout')
@section('head')

    <!-- BEGIN PAGE LEVEL PLUGINS -->
    <link href="/CRM_Assets/assets/global/plugins/datatables/datatables.min.css" rel="stylesheet" type="text/css"/>
    <link href="/CRM_Assets/assets/global/plugins/datatables/plugins/bootstrap/datatables.bootstrap-rtl.css"
          rel="stylesheet" type="text/css"/>
    <!-- END PAGE LEVEL PLUGINS -->
    <link href="/CRM_Assets/assets/global/plugins/select2/css/select2.min.css" rel="stylesheet" type="text/css"/>
    <link href="/CRM_Assets/assets/global/plugins/select2/css/select2-bootstrap.min.css" rel="stylesheet"
          type="text/css"/>
@endsection
@section('content')
    <div class="page-header head-section">
        <a href="{{route('message.list')}}" class="previous-a round-a"><span class="glyphicon glyphicon-arrow-left"></span> <strong>بازگشت</strong> </a>
        @if(Auth::user()->can(['پیام های گروهی','همه','ارسال پیام']))
            <div class="btn-group" style="float: left; margin-right: 5px;margin-left: 19px">
                <button class="btn btn-sm btn-primary" data-toggle="modal" data-target="#myModalUserAdd" ><i class="fa fa-user-plus"></i> افزودن کاربر </button>
            </div>
        @endif
        <h3 style="text-align: center">
            <i class="fa fa-users"></i>
            کاربران پیام<span class="title bold" style="color:#ff4f4f"> {{$message->subject}} </span>
        </h3>
    </div>
    <div id="alerts">

        @include('errors.formAlert')
    </div>
    <div class="panel panel-default">
        <div class="panel-heading">
            <h3 class="panel-title FarsiFont"><i class="fa fa-list"></i>&nbsp;مدیریت کاربران پیام ها</h3>
        </div>
        <div class="panel-body">
            <div id="table">
                <table class="table table-striped table-bordered table-hover order-column dataTable no-footer" id="sample_1" role="grid" aria-describedby="sample_1_info" >
                    <thead>
                    <tr role="row">
                        <th class="text-center"> کاربر </th>
                        <th class="text-center"> وضعیت </th>
                        <th class="text-center"> تاریخ مشاهده </th>
                        <th class="text-center"><i class="fa fa-trash"></i></th>
                    </tr>
                    </thead>
                    <tbody>
                    @isset($users)
                        @foreach($users as $user)
                            @php

                                $pivot = $user->getUserMessagePivot($message)

                            @endphp
                            <tr role="row" @if(is_null($pivot->seen)) class="danger" @else class="success" @endif >
                                <td class="text-center"><a href="{{route('carts.user.index',$user)}}">{{$user->fname}} {{$user->lname}} {{$user->mobile}}</a></td>
                                <td class="text-center" style="direction: ltr">
                                    @if(is_null($pivot->seen)) خوانده نشده @else خوانده شده @endif
                                </td>
                                <td class="text-center" >
                                    @if(is_null($pivot->seen)) - @else {{persianDiffForHumans($pivot->seen)}}  @endif
                                </td>
                                <td class="text-center">
                                    <form action="{{route('message.users.destroy',$pivot)}}" method="POST">
                                        {{csrf_field()}}
                                        {{method_field('DELETE')}}
                                        <button type="submit" class="btn btn-xs btn-danger"  data-toggle="tooltip" data-original-title="حذف"><i class="fa fa-trash"></i></button>
                                    </form>
                                </td>
                            </tr>
                        @endforeach
                    @endisset
                    </tbody>
                </table>
            </div>
        </div>
    </div>
@endsection
@section('modal')
    <div class="modal fade" id="myModalUserAdd" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
        <div class="modal-dialog" style="z-index: 100;width: 600px;">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                    <h4 class="modal-title" id="myModalLabel"><i class="fa fa-user-plus"></i> افزودن کاربر </h4>
                </div>
                <div class="modal-body">
                    <form class="form-horizontal" action="{{route('message.users.add',$message)}}" role="form" method="POST">
                        {{csrf_field()}}
                        <div class="form-group" style="margin-bottom: 55px;margin-top: 55px;">
                            <label for="user" class="col-sm-3 control-label">کاربران</label>
                            <div class="col-sm-9">
                                <select class="select2me" name="user_id[]" id="user" required multiple="multiple">
                                    <option value="all">همه کاربران</option>
                                    @foreach($users2 as $user2)
                                        <option value="{{$user2->id}}">{{$user2->fname}} {{$user2->lname}} ({{$user2->mobile}})</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="modal-footer" style="text-align: center;">
                            <button type="submit" class="btn btn-success" style="width: 50%;">ثبت</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

@endsection
@section('script')
    <script src="/CRM_Assets/assets/global/plugins/select2/js/select2.full.min.js" type="text/javascript"></script>
    <script src="/CRM_Assets/assets/global/scripts/datatable.js" type="text/javascript"></script>
    <script src="/CRM_Assets/assets/global/plugins/datatables/datatables.min.js" type="text/javascript"></script>
    <script src="/CRM_Assets/assets/global/plugins/datatables/plugins/bootstrap/datatables.bootstrap.js" type="text/javascript"></script>

    <script src="/CRM_Assets/assets/pages/scripts/table-datatables-managed.min.js" type="text/javascript"></script>

@endsection
@section('footer')

@endsection