@extends('/CRM/layout')
@section('head')

    <link rel="stylesheet" href="/jq-confirm/jquery-confirm.min.css">
    <!-- BEGIN PAGE LEVEL PLUGINS -->
    <link href="/CRM_Assets/assets/global/plugins/datatables/datatables.min.css" rel="stylesheet" type="text/css" />
    <link href="/CRM_Assets/assets/global/plugins/datatables/plugins/bootstrap/datatables.bootstrap-rtl.css" rel="stylesheet" type="text/css" />
    <!--END PAGE LEVEL PLUGINS -->
    <style>
        #filter-link{
            text-shadow: none;
            color: #fff;
            text-decoration: none;
        }

       #filter-link:hover{
            text-decoration: none;
            color: #5394cf;
        }
    </style>
@endsection
@section('content')

    @if(session()->has('message') && session()->has('messageType'))
        <br>
        @if(session('messageType') == 'success')
            <div class="alert alert-success">
                <p>{{session('message')}}</p>
            </div>
        @elseif(session('messageType') == 'failure')
            <div class="alert alert-danger">
                <p>{{session('message')}}</p>
            </div>
        @endif
    @endif
    <div class="row">
        <div class="col-md-12">
            <!-- BEGIN EXAMPLE TABLE PORTLET-->
            <div class="portlet light bordered">
                <div class="portlet-title">
                    <div class="caption font-dark">
                        <i class="fa fa-filter font-dark" style="font-size: 1.5em"></i>
                        <span class="caption-subject bold uppercase">مدیریت فیلتر ها</span>
                    </div>
                </div>
                <div class="portlet-body">
                    <div class="table-toolbar">
                        <div class="row">
                            <div class="col-md-6">

                            </div>
                            <div class="col-md-6">
                            </div>
                        </div>
                    </div>
                    <div id="sample_1_wrapper" class="dataTables_wrapper no-footer">
                        <div class="row">
                        </div>
                        <div class="table">
                            <table class="table table-striped table-bordered table-hover order-column dataTable no-footer" id="sample_1" role="grid" aria-describedby="sample_1_info" >
                                <thead>
                                <tr role="row">
                                    <th class="sorting_disable text-center"  style="width: 10px;" aria-label=""> </th>
                                    <th class="sorting_desc text-center" tabindex="0" aria-controls="sample_1" rowspan="1" colspan="1"  style="width: 80px;" aria-sort="descending" aria-label=" Id : activate to sort column ascending"> شناسه </th>
                                    <th class="sorting text-center" tabindex="0" aria-controls="sample_1" rowspan="1" colspan="1"   aria-label=" Category : activate to sort column ascending"> دسته بندی </th>
                                    <th class="sorting text-center" tabindex="0" aria-controls="sample_1" rowspan="1" colspan="1"  aria-label=" Status : activate to sort column ascending">عنوان فیلتر </th>
                                </tr>
                                </thead>
                                <tbody>
                                @if( isset($category) && count($category)>0)

                                    @foreach($category as $cat)
                                        @php
                                            $filterTitle = $cat->FilterTitle()->first();
                                        @endphp

                                        <tr role="row"
                                            @if(isset($filterTitle))
                                            class="success"
                                            @else
                                            class="danger"
                                                @endif
                                        >
                                            <td >

                                            </td>
                                            <td class="text-center">{{$cat->id}}</td>
                                            <td class="text-center">
                                                <a href="{{ route('filterTitles.show' , ['id' => $cat->id ]) }}">{{$cat->category}} </a>
                                            </td>
                                            @php
                                                $titles = $cat->FilterTitle;
                                            @endphp
                                            @if($titles->count()>0)
                                                <td>
                                                    <div class="portlet-body">
                                                        <div class="mt-element-list">
                                                            <div class="mt-list-container list-default ext-1 group">
                                                                @foreach($titles as $title)
                                                                    @php
                                                                        $option = $title->Filter
                                                                    @endphp
                                                                    @if($title->status == 1)
                                                                        <a class="list-toggle-container collapsed" data-toggle="collapse" href="#completed{{$cat->id}}{{$loop->iteration}}" aria-expanded="false">
                                                                            <div class="list-toggle done uppercase"> {{$title->name}} -
                                                                                @if($title->status == 1)
                                                                                 (فعال)
                                                                                @else
(غیرفعال)
                                                                                @endif

                                                                                <span class="badge badge-default pull-right bg-white font-green bold"><span>گزینه های موجود</span>: {{$option->count()}}</span>
                                                                            </div>
                                                                        </a>
                                                                        <div class="panel-collapse collapse" id="completed{{$cat->id}}{{$loop->iteration}}" aria-expanded="false" style="height: 0px;">
                                                                            <div class="mt-list-head list-news ext-1 font-white bg-grey-gallery">
                                                                                <div class="list-head-title-container">
                                                                                    @if($option->count() > 0)
                                                                                    <h3 class="list-title">لیست گزینه های موجود در فیلتر</h3>
                                                                                        @else
                                                                                        <h3 class="list-title">هنوز هیچ گزینه ای در این فیلتر تعریف نشده</h3>
                                                                                    @endif
                                                                                </div>
                                                                                <div class="list-count pull-right bg-red" >
                                                                                    <a  id="filter-link" href="{{ route('options.show' , ['id' => $title->id,'catId' => $cat->id ]) }}"> نمایش</a>
                                                                                </div>
                                                                            </div>
                                                                            <ul>
                                                                                @foreach($option as $op)
                                                                                    <li class="mt-list-item done">
                                                                                        <div class="list-icon-container">
                                                                                            <a href="javascript:;">
                                                                                                @if($op->status == 1)
                                                                                                    <i class="icon-check"></i>
                                                                                                @else
                                                                                                    <i class="icon-close"></i>
                                                                                                @endif
                                                                                            </a>
                                                                                        </div>
                                                                                        <div class="list-item-content">
                                                                                            <h3 class="uppercase">
                                                                                                <p>{{$op->name}}</p>
                                                                                            </h3>
                                                                                            @if($op->status == 1)
                                                                                                <p>فعال</p>

                                                                                            @else
                                                                                                <p>غیر فعال</p>
                                                                                            @endif
                                                                                        </div>
                                                                                    </li>
                                                                                @endforeach
                                                                            </ul>
                                                                        </div>
                                                                    @else
                                                                        <a class="list-toggle-container" data-toggle="collapse" href="#pending{{$cat->id}}{{$loop->iteration}}" aria-expanded="false">
                                                                            <div class="list-toggle uppercase"> {{$title->name}} -
                                                                                @if($title->status == 1)
                                                                                    (فعال)
                                                                                @else
(غیرفعال)
                                                                                @endif
                                                                                <span class="badge badge-default pull-right bg-white font-green bold"><span>گزینه های موجود</span>: {{$option->count()}}</span>
                                                                            </div>
                                                                        </a>
                                                                        <div class="panel-collapse collapse" id="pending{{$cat->id}}{{$loop->iteration}}">
                                                                            <div class="mt-list-head list-news ext-1 font-white bg-grey-gallery">
                                                                                <div class="list-head-title-container">
                                                                                    @if($option->count() > 0)
                                                                                        <h3 class="list-title">لیست گزینه های موجود در فیلتر</h3>
                                                                                    @else
                                                                                        <h3 class="list-title">هنوز هیچ گزینه ای در این فیلتر تعریف نشده</h3>
                                                                                    @endif
                                                                                </div>
                                                                                <div class="list-count pull-right bg-red">
                                                                                    <a  id="filter-link" href="{{ route('options.show' , ['id' => $title->id,'catId' => $cat->id ]) }}"> ورود</a>
                                                                                </div>
                                                                            </div>
                                                                            <ul>
                                                                                @foreach($option as $op)

                                                                                <li class="mt-list-item">
                                                                                    <div class="list-icon-container">
                                                                                        <a href="javascript:;">
                                                                                            @if($op->status == 1)
                                                                                                <i class="icon-check"></i>
                                                                                            @else
                                                                                                <i class="icon-close"></i>
                                                                                            @endif
                                                                                        </a>
                                                                                    </div>
                                                                                    <div class="list-item-content">
                                                                                        <h3 class="uppercase">
                                                                                            <p>{{$op->name}}</p>
                                                                                        </h3>
                                                                                        @if($op->status == 1)
                                                                                            <p>فعال</p>

                                                                                        @else
                                                                                            <p>غیر فعال</p>
                                                                                        @endif
                                                                                    </div>
                                                                                </li>
                                                                                    @endforeach
                                                                            </ul>
                                                                        </div>
                                                                    @endif
                                                                @endforeach
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <span hidden>yes</span>
                                                    <ul>

                                                        {{--<li>--}}
                                                        {{--<a--}}
                                                        {{--@if($option->count() > 0)--}}
                                                        {{--class="badge bg-success bold"--}}
                                                        {{--@else--}}
                                                        {{--class="badge bg-danger bold"--}}
                                                        {{--@endif--}}
                                                        {{--</li>--}}

                                                    </ul>
                                                </td>
                                            @else
                                                <td class="text-center" title="ثبت نشده">
                                                    <span class="glyphicon glyphicon-remove font-red-mint"  style="font-size: 2em"><span hidden>no</span></span>
                                                </td>
                                            @endif
                                        </tr>
                                    @endforeach
                                @endif
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            <!-- END EXAMPLE TABLE PORTLET-->
        </div>
    </div>
@endsection


@section('script')
    <!-- BEGIN PAGE LEVEL PLUGINS -->
    <script src="/CRM_Assets/assets/global/scripts/datatable.js" type="text/javascript"></script>
    <script src="/CRM_Assets/assets/global/plugins/datatables/datatables.min.js" type="text/javascript"></script>
    <script src="/CRM_Assets/assets/global/plugins/datatables/plugins/bootstrap/datatables.bootstrap.js" type="text/javascript"></script>
    <!-- END PAGE LEVEL PLUGINS -->
    <!-- BEGIN PAGE LEVEL SCRIPTS -->
    <script src="/CRM_Assets/assets/pages/scripts/table-datatables-managed.min.js" type="text/javascript"></script>
    <!-- END PAGE LEVEL SCRIPTS -->

@endsection
