@extends('/CRM/layout')
@section('head')
    <link href="/CRM_Assets/assets/global/plugins/select2/css/select2.min.css" rel="stylesheet" type="text/css"/>
    <link href="/CRM_Assets/assets/global/plugins/select2/css/select2-bootstrap.min.css" rel="stylesheet"
          type="text/css"/>
    <style>
        .form-horizontal .control-label {
            text-align: right;
            padding-top: 7px;
            margin-bottom: 12px;
        }
    </style>
@endsection
@section('content')
    <div class="portlet light bordered main">
        <a href="{{ url('/CRM/SiteFront/dynamicMenu/'.$dynamicSubMenu->DynamicMenu->id)}}" class="previous-a round-a"><span class="glyphicon glyphicon-arrow-left"></span> بازگشت </a>

        <div class="page-header head-section">
            <h2>ویرایش زیر منو {{$dynamicSubMenu->name}}</h2>
        </div>
        <form class="form-horizontal" action="{{ route('dynamicSubMenu.update' , ['id' => $dynamicSubMenu->id ]) }}" method="post" enctype="multipart/form-data">
            {{ csrf_field() }}
            {{ method_field('PATCH') }}
            @include('CRM.SiteFront.section.errors')
            <div style="margin-bottom: 40px">
                <div class="form-group">
                    <div class="col-md-6">
                        <label for="name" class="control-label">نوع منو</label>
                        <div class="mt-radio-inline">
                            <label class="mt-radio">

                            </label>
                            <label class="mt-radio">
                                <input class="menu_type" name="type"  value="1" type="radio" @if(old('type',$dynamicSubMenu->type) == 1) checked @endif> بر اساس دسته بندی
                                <span></span>
                            </label>
                            <label class="mt-radio">
                                <input class="menu_type" name="type"  value="2" type="radio" @if(old('type',$dynamicSubMenu->type) == 2) checked @endif> بر اساس URL
                                <span></span>
                            </label>
                        </div>
                    </div>
                </div>
                <div class="form-group">
                    <div class="col-md-6">
                        <input type="hidden"  class="form-control" name="dynamic_menu_id" id="dynamic_menu_id" value="{{$dynamicMenu->id}}">
                        <label for="name" class="control-label">عنوان زیر منو</label>
                        <input type="text" class="form-control" name="name" id="name" placeholder="عنوان را وارد کنید" value="{{ old('name',$dynamicSubMenu->name) }}">
                    </div>
                </div>
                <div class="form-group" id="stuffType_section" @if($dynamicSubMenu->type == 2) style="display: none" @endif>
                    <div class="col-md-6">
                        <label for="category_id" class="control-label">دسته بندی مربوطه</label>
                        <br>
                        <select  class="form-control select2me" name="category_id" id="category_id" >
                            @foreach($categories as $category)
                                <option value="{{$category->id}}" @if(old('$dynamicSubMenu',$dynamicSubMenu->id) == $category->id) selected @endif>{{$category->category}} ({{$category->id}})</option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <div class="form-group" id="url_section" @if($dynamicSubMenu->type == 1) style="display: none" @endif>
                    <div class="col-md-12">
                        <label class="control-label" style="margin-bottom: 10px;">URL</label>
                        <br>
                        <div class="input-group">
                            <span class="input-group-addon">
                                <i class="fa fa-link"></i>
                            </span>
                            <input name="url" type="url" value="{{old('url',$dynamicSubMenu->url)}}" class="form-control"  placeholder="آدرس URL مورد نظر را وارد کنید" required>
                        </div>
                    </div>
                </div>
            </div>
            <div class="form-group">
                <div class="col-sm-12">
                    <button type="submit" class="btn btn-danger" style="width: 105px;">ویرایش</button>
                </div>
            </div>
        </form>
    </div>
@endsection

@section('script')
    <script src="/CRM_Assets/ckeditor/ckeditor.js" type="text/javascript"></script>
    <script src="/CRM_Assets/assets/global/plugins/select2/js/select2.full.min.js" type="text/javascript"></script>
@endsection

@section('footer')
    <script>
        $('.menu_type').click(function () {
            var type = $(this).val();

            if(type == 1){
                $('#url_section').fadeOut('slow');
                $('#stuffType_section').fadeIn('slow');

            }else if(type == 2){
                $('#stuffType_section').fadeOut('slow');
                $('#url_section').fadeIn('slow');
            }

        })
    </script>
@endsection