@extends('/CRM/layout')
@section('head')
    <link href="/CRM_Assets/assets/global/plugins/select2/css/select2.min.css" rel="stylesheet" type="text/css"/>
    <link href="/CRM_Assets/assets/global/plugins/select2/css/select2-bootstrap.min.css" rel="stylesheet"
          type="text/css"/>
@endsection
@section('content')
    <div class="portlet light bordered main">
        <a href="{{ url('/CRM/SiteFront/dynamicMenu/'.$dynamicMenu->id)}}" class="previous-a round-a"><span class="glyphicon glyphicon-arrow-left"></span> بازگشت </a>

        <div class="page-header head-section">
            <h2>ایجاد زیر منو</h2>
        </div>
        <br>
        <form class="form-horizontal" action="{{ route('dynamicSubMenu.store') }}" method="post" enctype="multipart/form-data">
            {{ csrf_field() }}
            @include('CRM.SiteFront.section.errors')
            <div class="form-group">
                <div class="col-md-6">
                    <input type="text" name="dynamic_menu_id"  value="{{$dynamicMenu->id}}" hidden>
                    <input type="text" name="type" value="1" hidden>

                    <label for="name" class="control-label" style="margin-bottom: 10px;">عنوان زیر منو</label>
                    <br>
                    <input type="text" class="form-control" name="name" id="name" placeholder="عنوان را وارد کنید" value="{{ old('name') }}" required>
                </div>
            </div>
            <div class="form-group">
                <div class="col-md-6">
                    <label for="category_id" class="control-label" style="margin-bottom: 10px;">دسته بندی مربوطه</label>
                    <br>
                    <select  class="form-control select2me" name="category_id" id="category_id" required>
                        @foreach($categories as $category)
                            <option value="{{$category->id}}"
                                    @if(old('category_id') == $category->id)
                                    selected
                                    @endif
                            >{{$category->category}} ({{$category->id}})</option>
                        @endforeach
                    </select>
                </div>
            </div>
            <br>
            <div class="form-group">
                <div class="col-sm-12">
                    <button type="submit" class="btn btn-danger" style="width: 105px;">ثبت</button>
                </div>
            </div>
        </form>
    </div>
@endsection
@section('script')
    <script src="/CRM_Assets/ckeditor/ckeditor.js" type="text/javascript"></script>
    <script src="/CRM_Assets/assets/global/plugins/select2/js/select2.full.min.js" type="text/javascript"></script>
@endsection