@extends('/CRM/layout')
@section('head')
    <link rel="stylesheet" href="/jq-confirm/jquery-confirm.min.css">
    <style>
        a.title:link, a.title:visited {
            padding: 1px 6px 1px 6px;
            text-align: center;
            text-decoration: none;
            display: inline-block;
        }


        a.title:hover, a.title:active {
            color: #ED6B75;
            text-decoration: none;
        }
    </style>
@endsection
@section('content')
    <div class="portlet light bordered main">

        <a href="{{ url('/CRM/SiteFront/dynamicMenu') }}" class="previous-a round-a"><span class="glyphicon glyphicon-arrow-left"></span> بازگشت </a>

        <div class="page-header head-section">
            <div class="btn-group pull-right" >
                <button type="button" data-toggle="tooltip" id="delete_all"  class="btn btn-xs btn-danger" onclick="" data-original-title="حذف"><i class="icon-trash"></i></button>
            </div>
            <div class="btn-group pull-left" style="margin-right: 5px;margin-left: 19px" >
                <a type="button" id="activation_button" class="btn btn-xs btn-primary" data-toggle="modal" data-target="#exampleModal" data-whatever="@mdo">فعال سازی زیرمنوها</a>
            </div>
            <div class="btn-group pull-left" style="margin-right: 5px;margin-left: 30px">
                <a href="{{ route('dynamicSubMenu.create-cat', $dynamicMenus ) }}" class="btn btn-xs btn-outline red-haze" data-toggle="tooltip" data-original-title="ایجاد زیرمنو بر اساس دسته بندی">دسته بندی</a>
                <a href="{{ route('dynamicSubMenu.createUrl',$dynamicMenus) }}" class="btn btn-xs btn-outline blue" data-toggle="tooltip" data-original-title="ایجاد زیرمنو بر اساس URL">URL</a>
            </div>
            <h3 style="text-align: center"><i class="fa fa-list" aria-hidden="true"></i> زیر منوهای "<a href="{{ url('/CRM/SiteFront/dynamicMenu') }}" class="title bold">{{$dynamicMenus->name}}</a>"
            </h3>
        </div>
        <div id="menu_content">
            @include("CRM.SiteFront.dynamicSubMenu.subMenuTablesInclude")
        </div>
    </div>

@endsection
@section('modal')
    <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title bold" id="exampleModalLabel">فعال سازی زیر منو ها</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form class="form-horizontal" action="" role="form" method="POST" enctype="multipart/form-data">
                        <div class="form-group" id="sub_menu_1">
                            <label for="dynamicSubMenu_1" class="form-control-label col-md-3">منوی اول:</label>
                            <select class="form-control input-large col-md-9 " name="dynamicSubMenu_1" id="dynamicSubMenu_1" data-placeholder="انتخاب کنید..." chosen>
                                <option value="0">غیر فعال</option>
                                @php
                                    $i = 1;
                                @endphp
                                @foreach($dynamicSubMenu as $menu)
                                    <option value="{{$menu->id}}">{{$i}} -  {{$menu->name}} ({{$menu->id}})</option>
                                    @php
                                        $i++;
                                    @endphp
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group" id="sub_menu_2">
                            <label for="dynamicSubMenu_2" class="form-control-label col-md-3">منوی دوم:</label>
                            <select class="form-control input-large col-md-9" name="dynamicSubMenu_2" id="dynamicSubMenu_2" data-placeholder="انتخاب کنید..." chosen>
                                <option value="0">غیر فعال</option>
                                @php
                                    $i = 1;
                                @endphp
                                @foreach($dynamicSubMenu as $menu)
                                    <option value="{{$menu->id}}">{{$i}} -  {{$menu->name}} ({{$menu->id}})</option>
                                    @php
                                        $i++;
                                    @endphp
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group" id="sub_menu_3">
                            <label for="dynamicSubMenu_3" class="form-control-label col-md-3">منوی سوم:</label>
                            <select class="form-control input-large col-md-9" name="dynamicSubMenu_3" id="dynamicSubMenu_3" data-placeholder="انتخاب کنید..." chosen>
                                <option value="0">غیر فعال</option>
                                @php
                                    $i = 1;
                                @endphp
                                @foreach($dynamicSubMenu as $menu)
                                    <option value="{{$menu->id}}">{{$i}} -  {{$menu->name}} ({{$menu->id}})</option>
                                    @php
                                        $i++;
                                    @endphp
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group" id="sub_menu_4">
                            <label for="dynamicSubMenu_4" class="form-control-label col-md-3">منوی چهارم:</label>
                            <select class="form-control input-large col-md-9" name="dynamicSubMenu_4" id="dynamicSubMenu_4" data-placeholder="انتخاب کنید..." chosen>
                                <option value="0">غیر فعال</option>
                                @php
                                    $i = 1;
                                @endphp
                                @foreach($dynamicSubMenu as $menu)
                                    <option value="{{$menu->id}}">{{$i}} -  {{$menu->name}} ({{$menu->id}})</option>
                                    @php
                                        $i++;
                                    @endphp
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group" id="sub_menu_5">
                            <label for="dynamicSubMenu_5" class="form-control-label col-md-3">منوی پنجم:</label>
                            <select class="form-control input-large col-md-9" name="dynamicSubMenu_5" id="dynamicSubMenu_5" data-placeholder="انتخاب کنید..." chosen>
                                <option value="0">غیر فعال</option>
                                @php
                                    $i = 1;
                                @endphp
                                @foreach($dynamicSubMenu as $menu)
                                    <option value="{{$menu->id}}">{{$i}} -  {{$menu->name}} ({{$menu->id}})</option>
                                    @php
                                        $i++;
                                    @endphp
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group" id="sub_menu_6">
                            <label for="dynamicSubMenu_6" class="form-control-label col-md-3">منوی ششم:</label>
                            <select class="form-control input-large col-md-9" name="dynamicSubMenu_6" id="dynamicSubMenu_6" data-placeholder="انتخاب کنید..." chosen>
                                <option value="0">غیر فعال</option>
                                @php
                                    $i = 1;
                                @endphp
                                @foreach($dynamicSubMenu as $menu)
                                    <option value="{{$menu->id}}">{{$i}} -  {{$menu->name}} ({{$menu->id}})</option>
                                    @php
                                        $i++;
                                    @endphp
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group" id="sub_menu_7">
                            <label for="dynamicSubMenu_7" class="form-control-label col-md-3">منوی هفتم:</label>
                            <select class="form-control input-large col-md-9" name="dynamicSubMenu_7" id="dynamicSubMenu_7" data-placeholder="انتخاب کنید..." chosen>
                                <option value="0">غیر فعال</option>
                                @php
                                    $i = 1;
                                @endphp
                                @foreach($dynamicSubMenu as $menu)
                                    <option value="{{$menu->id}}">{{$i}} -  {{$menu->name}} ({{$menu->id}})</option>
                                    @php
                                        $i++;
                                    @endphp
                                @endforeach
                            </select>
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-primary" id="MenuActivation" >ثبت</button>
                    <button type="button" class="btn btn-danger" data-dismiss="modal">لغو</button>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('footer')
    <script src="/jq-confirm/jquery-confirm.min.js"></script>
    <script>
        var menuId = "{{ $dynamicMenus->id }}";

        //--------------set values od modal-----------------\\
        $(document).on('click', '#activation_button', function () {
            $.ajax({
                url: "/CRM/SiteFront/activation_button?id="+menuId,
                type:"GET",
                cache: true,
                success: function( response2 ) {

                    for(var i=0; i<8; i++){
                        var x = i+1;
                        if(response2[i] === undefined){
                            $("#dynamicSubMenu_"+x+"").val(0);
                        }else{
                            $("#dynamicSubMenu_"+x+"").val(response2[i]);
                        }
                    }
                }
            })
        });
        //--------------active sub menus-----------------\\

        $(document).on('click', '#MenuActivation', function () {

            $.confirm({
                title: 'فعال سازی منو ها',
                content: 'آیا مطمئن هستید؟',
                buttons: {
                    somethingElse: {
                        text: 'تایید',
                        btnClass: 'btn-blue',
                        action: function () {
                            var dynamicSubMenu = [
                                $('#dynamicSubMenu_1').val(),$('#dynamicSubMenu_2').val(),
                                $('#dynamicSubMenu_3').val(),$('#dynamicSubMenu_4').val(),
                                $('#dynamicSubMenu_5').val(),$('#dynamicSubMenu_6').val(),
                                $('#dynamicSubMenu_7').val()
                            ];
                            ////ajax baraye update kardane etelaate menu
                            $.ajax({
                                url     : "/CRM/SiteFront/subMenuActivation",
                                type    :"POST",
                                cash    : false,
                                data    :{ dynamicSubMenu : dynamicSubMenu, menuId: menuId, _token: $('#token').val()},
                                success: function( response ) {
                                    $('#exampleModal').modal('hide');
                                    if(response == 103){
                                        swal({
                                            title: "خطا",
                                            text: 'نمی توانید بیش از یک بار زیر منو را فعال کنید',
                                            type: "error",
                                            showConfirmButton: true,
                                            confirmButtonText : 'باشه'
                                        });
                                    }else if(response == 104){
                                        swal({
                                            title: "غیر فعال شد",
                                            text: 'همه زیر منو ها با موفقیت غیر فعال شدند',
                                            type: "success",
                                            showConfirmButton: false,
                                            timer : 1500
                                        });
                                    }else if(response == 200){
                                        swal({
                                            title: "فعال شد",
                                            text: 'زیر منو ها با موفقیت فعال شدند',
                                            type: "success",
                                            showConfirmButton: false,
                                            timer : 1500
                                        });

                                    }
                                    if (response == 104 || response == 200) {

                                        //ajax refresh jadval
                                        $.ajax({
                                            url: "/CRM/SiteFront/subMenuTableRefresh?id=" + menuId,
                                            type: "GET",
                                            cache: false,
                                            success: function (response2) {
                                                $("#menu_content").html(response2);

                                            }
                                        })
                                    }
                                }
                            })
                        }
                    },
                    somethingElse2: {
                        text: 'خیر',
                        btnClass: 'btn-red',
                        action: function () {
                            swal({
                                title: "تایید نشد",
                                type: "info",
                                showConfirmButton: false,
                                timer : 1000
                            });
                        }
                    }
                }
            });

        });
        //---------------Delete -----------------//
        $(document).on('click', '#delete_all', function () {
            var selected = new Array();
            $("input:checkbox[name*=selected]:checked").each(function(){
                selected.push($(this).val());
            });

            if($.isEmptyObject(selected)){
                swal({
                    title: "توجه",
                    text: 'لطفا یک زیر منو برای حذف انتخاب کنید',
                    type: "info",
                    showConfirmButton: true,
                    confirmButtonText : 'باشه'
                });
            }else{
                $.confirm({
                    title: 'حذف زیر منو ها',
                    content: 'آیا مطمئن هستید؟',
                    buttons: {
                        somethingElse: {
                            text: 'تایید',
                            btnClass: 'btn-blue',
                            action: function () {
                                $.ajaxSetup({
                                    headers: {
                                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                                    }
                                });
                                $.ajax({
                                    url     : "<?= url('/CRM/SiteFront/subMenuDelete') ?>",
                                    type    :"POST",
                                    cash    : false,
                                    data    :{ data : selected , id: menuId,_token: $('#token').val() },
                                    success: function(response2) {
                                        $('#myModal').modal('hide');
                                        swal({
                                            title: "حذف شد",
                                            text: "زیر منو با موفقیت حذف شد",
                                            type: "success",
                                            showConfirmButton: false,
                                            timer : 1500
                                        });
                                        $("#menu_content").html(response2);
                                    }
                                });
                            }
                        },
                        somethingElse2: {
                            text: 'خیر',
                            btnClass: 'btn-red',
                            action: function () {
                                swal({
                                    title: "تایید نشد",
                                    type: "info",
                                    showConfirmButton: false,
                                    timer : 1000
                                });

                            }
                        }
                    }
                });
            }
        });
    </script>
@endsection