@extends('/CRM/layout')
@section('head')
    <link href="/CRM_Assets/assets/global/plugins/select2/css/select2.min.css" rel="stylesheet" type="text/css"/>
    <link href="/CRM_Assets/assets/global/plugins/select2/css/select2-bootstrap.min.css" rel="stylesheet"
          type="text/css"/>
    <style>
        .form-horizontal .control-label {
            text-align: right;
            padding-top: 7px;
            margin-bottom: 12px;
        }
    </style>
@endsection
@section('content')
    <div class="portlet light bordered main">
        <a href="{{ url('/CRM/SiteFront/dynamicMenu') }}" class="previous-a round-a"><span class="glyphicon glyphicon-arrow-left"></span> بازگشت </a>

        <div class="page-header head-section">
            <h2>ویرایش منو {{$dynamicMenu->name}}</h2>
        </div>
        <div class="portlet-body">


            <form class="form-horizontal" action="{{ route('dynamicMenu.update' ,$dynamicMenu) }}" method="post" enctype="multipart/form-data">
                {{ csrf_field() }}
                {{ method_field('PATCH') }}
                @include('errors.formAlert')
                <div style="margin-bottom: 40px">
                    <div class="form-group">
                        <div class="col-md-6">
                            <label for="name" class="control-label">نوع منو</label>
                            <div class="mt-radio-inline">
                                <label class="mt-radio">

                                </label>
                                <label class="mt-radio">
                                    <input class="menu_type" name="type"  value="1" type="radio" @if(old('type',$dynamicMenu->type) == 1) checked @endif> بر اساس نوع کالا
                                    <span></span>
                                </label>
                                <label class="mt-radio">
                                    <input class="menu_type" name="type"  value="2" type="radio" @if(old('type',$dynamicMenu->type) == 2) checked @endif> بر اساس URL
                                    <span></span>
                                </label>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="col-md-6">
                            <label for="name" class="control-label">عنوان منو</label>
                            <input type="text" class="form-control" name="name" id="name" placeholder="عنوان را وارد کنید" value="{{$dynamicMenu->name or old('name') }}">
                        </div>
                    </div>
                    <div class="form-group" id="stuffType_section" @if($dynamicMenu->type == 2) style="display: none" @endif>
                        <div class="col-md-6">
                            <label for="stuffType_id" class="control-label">نوع کالای مربوطه</label>
                            <select  class="form-control select2me" name="stuffType_id" id="stuffType_id">
                                @foreach($stuffTypes as $stuffType)
                                    <option value="{{$stuffType->id}}" @if(old('stuffType_id',$dynamicMenu->stuffType_id) == $stuffType->id) selected @endif> {{$stuffType->stuffType}} ({{$stuffType->id}})</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="form-group" id="url_section" @if($dynamicMenu->type == 1) style="display: none" @endif>
                        <div class="col-md-12">
                            <label class="control-label">URL</label>
                            <div class="input-group">
                            <span class="input-group-addon">
                                <i class="fa fa-link"></i>
                            </span>
                                <input name="url" type="url" value="{{old('url',$dynamicMenu->url)}}" class="form-control" required placeholder="آدرس URL مورد نظر را وارد کنید">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="form-group">
                    <div class="col-sm-12">
                        <button type="submit" class="btn btn-danger" style="width: 105px;">ویرایش</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection

@section('script')
    <script src="/CRM_Assets/ckeditor/ckeditor.js" type="text/javascript"></script>
    <script src="/CRM_Assets/assets/global/plugins/select2/js/select2.full.min.js" type="text/javascript"></script>
@endsection

@section('footer')
<script>
    $('.menu_type').click(function () {
        var type = $(this).val();

        if(type == 1){
            $('#url_section').fadeOut('slow');
            $('#stuffType_section').fadeIn('slow');

        }else if(type == 2){
            $('#stuffType_section').fadeOut('slow');
            $('#url_section').fadeIn('slow');
        }

    })
</script>
@endsection