@extends('/CRM/layout')

@section('head')
    <link href="/CRM_Assets/assets/global/plugins/select2/css/select2.min.css" rel="stylesheet" type="text/css"/>
    <link href="/CRM_Assets/assets/global/plugins/select2/css/select2-bootstrap.min.css" rel="stylesheet"
          type="text/css"/>
@endsection

@section('content')
    <div class="portlet light bordered main">
        <a href="{{ url('/CRM/SiteFront/dynamicMenu') }}" class="previous-a round-a"><span class="glyphicon glyphicon-arrow-left"></span> بازگشت </a>

        <div class="page-header head-section">
            <h2>ایجاد منو</h2>
        </div>
        <br>
        <form class="form-horizontal" action="{{ route('dynamicMenu.store') }}" method="post">
            {{ csrf_field() }}
            @include('CRM.SiteFront.section.errors')
            <input value="1" type="text" name="type" hidden>
            <div class="form-group">
                <div class="col-md-6">
                    <label for="name" class="control-label" style="margin-bottom: 10px;">عنوان منو</label>
                    <br>
                    <input type="text" class="form-control" name="name" id="name" placeholder="عنوان را وارد کنید" value="{{ old('name') }}">
                </div>
            </div>
            <br>
            <div class="form-group">
                <div class="col-md-6">
                    <label for="stuffType_id" class="control-label" style="margin-bottom: 10px;">نوع کالای مربوطه</label>
                    <br>
                    <select class="form-control select2me" name="stuffType_id" id="stuffType_id">
                        @foreach($stuffTypes as $stuffType)
                            <option value="{{$stuffType->id}}" @if(old('stuffType_id') == $stuffType->id) selected @endif>{{$stuffType->stuffType}} ({{$stuffType->id}})</option>
                        @endforeach
                    </select>
                </div>
            </div>
            <br>
            <div class="form-group">
                <div class="col-sm-12">
                    <button type="submit" class="btn btn-danger" style="width: 105px;">ثبت</button>
                </div>
            </div>
        </form>
    </div>
@endsection

@section('script')
    <script src="/CRM_Assets/ckeditor/ckeditor.js" type="text/javascript"></script>
    <script src="/CRM_Assets/assets/global/plugins/select2/js/select2.full.min.js" type="text/javascript"></script>
@endsection
