@extends('/CRM/layout')
@section('head')

    <link rel="stylesheet" href="/jq-confirm/jquery-confirm.min.css">

    <style>
        .mt-comments a {
            text-decoration: none!important;
        }
        .mt-comments a:hover {
            color:#FF4F4F!important;
        }
    </style>
@endsection
@section('content')

    @if(session()->has('message') && session()->has('messageType'))
        <br>
        @if(session('messageType') == 'success')
            <div class="alert alert-success">
                <p>{{session('message')}}</p>
            </div>
        @elseif(session('messageType') == 'failure')
            <div class="alert alert-danger">
                <p>{{session('message')}}</p>
            </div>
        @endif
    @endif
    <div class="row">
        <div class="col-md-12">
            <!-- BEGIN EXAMPLE TABLE PORTLET-->
            <div class="portlet light bordered">
                <div class="portlet-title">
                    <div class="caption font-dark">
                        <i class="fa fa-comments font-dark" style="font-size: 1.7em"></i>
                        <span class="caption-subject bold uppercase">مدیریت نظرات</span>
                    </div>
                </div>
                <div class="portlet-body">
                    <div id="sample_1_wrapper" class="dataTables_wrapper no-footer">
                        <div class="portlet light ">
                            <div class="portlet-body">
                                <div class="tab-content">
                                    <div class="tab-pane active" id="portlet_comments_1">
                                        <!-- BEGIN: Comments -->
                                        <div class="mt-comments">
                                            @if(Auth::user()->can(['مدیریت نظرات','همه','نظرات در انتظار تایید']))
                                                <a href="{{route('pending.show')}}">
                                                    <div class="mt-comment">
                                                        <div class="mt-comment-img">
                                                            <i class="fa fa-commenting" style="font-size: 1.5em;"></i>
                                                        </div>
                                                        <div class="mt-comment-body">
                                                            <div class="mt-comment-info">
                                                                <span class="mt-comment-author">نظرات در انتظار تایید</span>
                                                            </div>
                                                            <div class="mt-comment-text">در این بخش میتوانید نظرات در انتظار تایید را مشاهده و تایید کنید </div>
                                                        </div>
                                                    </div>
                                                </a>
                                                <hr>
                                            @endif
                                            @if(Auth::user()->can(['مدیریت نظرات','همه','نظرات تایید شده']))
                                                <a href="{{route('approved.show')}}">
                                                    <div class="mt-comment">
                                                        <div class="mt-comment-img">
                                                            <i class="fa fa-check" style="font-size: 1.5em;"></i>
                                                        </div>
                                                        <div class="mt-comment-body">
                                                            <div class="mt-comment-info">
                                                                <span class="mt-comment-author">نظرات تایید شده</span>
                                                            </div>
                                                            <div class="mt-comment-text">در این بخش میتوانید نظرات تایید شده را مشاهده کنید </div>
                                                        </div>
                                                    </div>
                                                </a>
                                                <hr>
                                            @endif
                                            @if(Auth::user()->can(['مدیریت نظرات','همه','نظرات تایید نشده']))
                                                <a href="{{route('declined.show')}}">
                                                    <div class="mt-comment">
                                                        <div class="mt-comment-img">
                                                            <i class="fa fa-times" style="font-size: 1.5em;"></i>
                                                        </div>
                                                        <div class="mt-comment-body">
                                                            <div class="mt-comment-info">
                                                                <span class="mt-comment-author">نظرات تایید نشده</span>
                                                            </div>
                                                            <div class="mt-comment-text">در این بخش میتوانید نظرات تایید نشده را مشاهده کنید </div>
                                                        </div>
                                                    </div>
                                                </a>
                                                <hr>
                                            @endif
                                            @if(Auth::user()->can(['مدیریت نظرات','همه','همه نظرات']))
                                                <a href="{{route('comments.show')}}">
                                                    <div class="mt-comment">
                                                        <div class="mt-comment-img">
                                                            <i class="fa fa-comments" style="font-size: 1.5em;"></i>
                                                        </div>
                                                        <div class="mt-comment-body">
                                                            <div class="mt-comment-info">
                                                                <span class="mt-comment-author">همه نظرات</span>
                                                            </div>
                                                            <div class="mt-comment-text">در این بخش میتوانید همه نظرات را مشاهده کنید </div>
                                                        </div>
                                                    </div>
                                                </a>
                                            @endif
                                        </div>
                                        <!-- END: Comments -->
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
            <!-- END EXAMPLE TABLE PORTLET-->
        </div>
    </div>
@endsection


@section('script')


@endsection
