@extends('/CRM/layout')
@section('head')
    <link rel="stylesheet" href="/jq-confirm/jquery-confirm.min.css">

    <link rel="stylesheet"
          href="/CRM_Assets/assets/global/plugins/PersianDateTimePicker/Content/bootstrap-theme.min.css"/>
    <style>
        a.title:link, a.title:visited {
            padding: 1px 6px 1px 6px;
            text-align: center;
            text-decoration: none;
            display: inline-block;
        }

        a.title:hover, a.title:active {
            color: #ED6B75;
            text-decoration: none;
        }

        .popover {
            z-index: 90000 !important;
            max-width: 290px;
            font-family: IRANSANS;
        }

        .popover-title {
            font-family: IRANSANS;
        }
    </style>
@endsection
@section('content')
    <div class="page-header head-section">
        <h3 style="text-align: center">
            <i class="fa fa-edit"></i>
            ویرایش<span class="title bold" style="color:#ff4f4f"> نظر</span>
        </h3>
    </div>
    <div id="alerts">
        @include('errors.formAlert')
    </div>
    <div class="panel panel-default">
        <div class="panel-heading">
            نظر برای {{$review->Product->name}} /توسط کاربر: {{$review->User->fname}} {{$review->User->lname}}  ({{$review->User->mobile}})  با نام مستعار {{$review->name}}
        </div>
        <div class="panel-body">
            <div id="table">
                <form class="form-horizontal" method="POST" action="{{route('editReview.edit',$review)}}"
                      enctype='multipart/form-data' role="form">
                    {{csrf_field()}}
                    <div class="form-body">
                        <div class="form-group">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label class="col-md-2 control-label" for="text">متن نظر :</label>
                                    <div class="col-md-10">
                                        <textarea class="form-control" id="text" name="text" rows="10" style="width:70%;background: rgb(255, 255, 255) none repeat scroll 0% 0%; z-index: auto; position: relative; line-height: 20px; font-size: 14px; transition: none 0s ease 0s;">@if(old('text') != null){!! old('text') !!}@else{!! $review->text !!}@endif</textarea>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <div class="col-md-12">
                                        <label class="col-md-3 control-label">وضعیت :</label>
                                        <div class="col-md-9">
                                            <div class="mt-radio-inline">
                                                <label class="mt-radio">
                                                    <input name="confirmed" id="optionsRadios25" value="1"
                                                           @if(old('text') != null && old('text') == 1)
                                                                   checked
                                                                   @elseif($review->confirmed == 1)
                                                                   checked
                                                                   @endif
                                                           type="radio"> تایید کردن
                                                    <span></span>
                                                </label>
                                                <label class="mt-radio">
                                                    <input name="confirmed" id="optionsRadios26" value="2"
                                                           @if(old('text') != null && old('text') == 2)
                                                           checked
                                                           @elseif($review->confirmed == 2)
                                                           checked
                                                           @endif
                                                           type="radio"> رد کردن
                                                    <span></span>
                                                </label>
                                                <label class="mt-radio">
                                                    <input name="confirmed" id="optionsRadios26" value="0"
                                                           @if(old('text') != null && old('text') == 0)
                                                           checked
                                                           @elseif($review->confirmed == 0)
                                                           checked
                                                           @endif
                                                           type="radio"> در انتظار تایید
                                                    <span></span>
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-actions">
                        <button type="submit" class="btn green">ویرایش</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="panel panel-default">
        <div class="panel-heading">
            ثبت پاسخ برای این نظر
        </div>
        <div class="panel-body">
            <div id="table">
                <form class="form-horizontal" method="POST" action="{{route('editReview.replay',$review)}}"
                      enctype='multipart/form-data' role="form">

                    {{csrf_field()}}
                    <div class="form-body">
                        <div class="form-group">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label class="col-md-2 control-label" for="text">پاسخ نظر :</label>
                                    <div class="col-md-10">
                                        <textarea class="form-control" id="text" name="text" rows="10" style="width:70%;background: rgb(255, 255, 255) none repeat scroll 0% 0%; z-index: auto; position: relative; line-height: 20px; font-size: 14px; transition: none 0s ease 0s;"></textarea>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-actions">
                        <button type="submit" class="btn green">ثبت پاسخ</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="panel panel-default">
        <div class="panel-heading">
             پاسخ برای این نظر
        </div>
        <div class="portlet-body" style="height: 533px;overflow-y: scroll;">
            <div class="tab-content">
                <div class="tab-pane active" id="portlet_comments_1">
                    <!-- BEGIN: Comments -->
                    <div class="mt-comments">
                        @foreach($review->replay as $replay)
                        <div class="mt-comment">
                            <div class="mt-comment-img">
                                <img src="/CRM_Assets/assets/layouts/layout/img/comment.png"> </div>
                            <div class="mt-comment-body">
                                <div class="mt-comment-info">

                                    <span class="mt-comment-date">۰۴ شهریور، ۱۳۹۸ - ۱ دقیقه قبل</span>
                                </div>
                                <div class="mt-comment-text" style="line-height: 1.7">
                                    <span>نام: </span>
                                    <b>{{$replay->User->lname}}</b>
                                    <br>
                                    <br>
                                    <span>متن : </span>
                                    {{$replay->text}}
                                </div>
                                <div class="mt-comment-details">
                                    <ul class="mt-comment-actions">

                                        <li>
                                            <form action="{{route('deleteReplay',$replay->id)}}" method="post">
                                                {{csrf_field()}}
                                                <input type="hidden" name="id" value="{{$replay->id}}">
                                                <button  class="delete-comment">حذف</button>

                                            </form>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                            @endforeach
                    </div>
                    <!-- END: Comments -->
                </div>

            </div>
        </div>
    </div>


@stop
@section('script')

    <script src="/jq-confirm/jquery-confirm.min.js"></script>
@endsection
@section('footer')



@endsection