@extends('/CRM/layout')
@section('head')

    <link href="/CRM_Assets/assets/global/plugins/datatables/datatables.min.css" rel="stylesheet" type="text/css"/>
    <link href="/CRM_Assets/assets/global/plugins/datatables/plugins/bootstrap/datatables.bootstrap-rtl.css"
          rel="stylesheet" type="text/css"/>
@endsection
@section('content')
    <div class="page-header head-section">
        <div class="btn-group pull-left" style=" margin-right: 5px;margin-left: 19px">
            <button data-toggle="modal" data-target="#myModal" class="btn btn-sm btn-success"><span class="fa fa-plus"></span> افزودن کالا به سبد </button>
        </div>
        <div class="btn-group pull-right" style=" margin-right: 5px">
            <a href="{{route('carts.pending.index')}}" class="previous-a round-a"><i class="fa fa-arrow-right"></i> بازگشت </a>
        </div>
        <h3 style="text-align: center">
            <i class="fa fa-cart-plus"></i>
            ایجاد سبد خرید <span class="title bold" style="color:#ff4f4f">کاربران</span>
        </h3>
    </div>
    <div id="alerts">
        @include('errors.formAlert')
    </div>
    <div class="panel panel-default">
        <div class="panel-heading">
            <h3 class="panel-title FarsiFont"><i class="fa fa-list"></i>&nbsp;لیست کاربران و سبد خرید</h3>
        </div>
        <div class="panel-body">
            <table class="table table-striped table-bordered table-hover order-column dataTable no-footer" id="sample_1" role="grid" aria-describedby="sample_1_info" >
                <thead>
                <tr role="row">
                    <th class="text-center"> نام</th>
                    <th class="text-center"> موبایل</th>
                    <th class="text-center"> سبد خرید</th>
                    <th class="text-center"> سبد خرید فعال</th>
                    <th class="text-center"> تعداد اقلام</th>
                    <th class="text-center"> <i class="fa fa-gears"></i></th>
                </tr>
                </thead>
                <tbody>
                @isset($users)
                    @foreach($users as $user)
                        @php
                            $cart = $user->getActiveCart();
                        @endphp
                        <tr>
                            <td class="text-center">{{$user->fname}} {{$user->lname}}</td>
                            <td class="text-center">{{$user->mobile}}</td>
                            @if(isset($cart))
                                <td class="text-center"><i class="fa fa-check font-green"></i></td>
                                <td class="text-center">
                                    @if($cart->isActive())
                                        <i class="fa fa-check font-green"></i>
                                    @else
                                        <i class="fa fa-times font-red-haze"></i>
                                    @endif
                                </td>
                                <td class="text-center">{{convert($cart->CartProduct()->sum('qty'))}}</td>
                            @else
                                <td class="text-center"><i class="fa fa-times font-red-haze"></i></td>
                                <td class="text-center"><i class="fa fa-times font-red-haze"></i></td>
                                <td class="text-center">-</td>
                            @endif
                            <td class="text-center">
                                @if(isset($cart))
                                    <a href="{{route('editCart',$cart)}}" class="btn btn-xs btn-primary" data-toggle="tooltip" data-original-title="افزودن کالا"><i class="fa fa-plus"></i></a>
                                @else
                                    <a href="{{route('createCart',$user)}}" class="btn btn-xs btn-primary" data-toggle="tooltip" data-original-title="افزودن کالا"><i class="fa fa-plus"></i></a>
                                @endif
                            </td>
                        </tr>
                    @endforeach
                @endisset
                </tbody>
            </table>
        </div>
    </div>
@endsection
@section('modal')

@endsection
@section('script')
    <script src="/CRM_Assets/assets/global/scripts/datatable.js" type="text/javascript"></script>
    <script src="/CRM_Assets/assets/global/plugins/datatables/datatables.min.js" type="text/javascript"></script>
    <script src="/CRM_Assets/assets/global/plugins/datatables/plugins/bootstrap/datatables.bootstrap.js"
            type="text/javascript"></script>
    <!-- END PAGE LEVEL PLUGINS -->
    <!-- BEGIN PAGE LEVEL SCRIPTS -->
    <script src="/CRM_Assets/assets/pages/scripts/table-datatables-managed.min.js" type="text/javascript"></script>
@endsection
@section('footer')
    <script>
        $(document).ready(function() {
            $(':input[type="number"]').keydown(function (e) {
                // Allow: backspace, delete, tab, escape, enter and .
                if ($.inArray(e.keyCode, [46, 8, 9, 27, 13, 110, 190]) !== -1 ||
                    // Allow: Ctrl/cmd+A
                    (e.keyCode == 65 && (e.ctrlKey === true || e.metaKey === true)) ||
                    // Allow: Ctrl/cmd+C
                    (e.keyCode == 67 && (e.ctrlKey === true || e.metaKey === true)) ||
                    // Allow: Ctrl/cmd+X
                    (e.keyCode == 88 && (e.ctrlKey === true || e.metaKey === true)) ||
                    // Allow: home, end, left, right
                    (e.keyCode >= 35 && e.keyCode <= 39)) {
                    // let it happen, don't do anything
                    return;
                }
                // Ensure that it is a number and stop the keypress
                if ((e.shiftKey || (e.keyCode < 48 || e.keyCode > 57)) && (e.keyCode < 96 || e.keyCode > 105)) {
                    e.preventDefault();
                }
            });
        });
    </script>

@endsection