@extends('/CRM/layout')

@section('content')
    <div class="page-header head-section">
        <div class="btn-group" style="float: left; margin-right: 5px;margin-left: 19px">
            <button class="btn btn-sm btn-primary" data-toggle="modal" data-target="#modal-user-detail"><i class="fa fa-star-half-o"></i> جزئیات کاربر </button>
        </div>
        <h3 style="text-align: center">
            <i class="fa fa-user"></i>
            جزئیات خرید <span class="title bold" style="color:#ff4f4f">{{$user->fname}} {{$user->lname}} </span>{{convert($user->mobile)}}
        </h3>
    </div>
    <div id="alerts">
        @include('errors.formAlert')
    </div>
    <div class="panel panel-default">
        <div class="panel-heading">
            <h3 class="panel-title FarsiFont"><i class="fa fa-list"></i>&nbsp;مدیریت سبدهای خرید</h3>
        </div>
        <div class="panel-body">
            <div class="table-responsive">
                <table class="table table-striped table-bordered">
                    <thead>
                    <tr>
                        <th class="text-center"> شناسه</th>
                        <th class="text-center">سبد خرید</th>
                        <th class="text-center"> نام</th>
                        <th class="text-center"> تعداد</th>
                        <th class="text-center"> قیمت</th>
                        <th class="text-center">تاریخ</th>
                    </tr>
                    </thead>
                    <tbody>
                    @isset($carts_products)
                        @foreach($carts_products as $carts_product)
                            @php $product = \App\Models\CartProduct::getProduct($carts_product->id) @endphp
                            <tr>
                                <td class="text-center">{{convert($carts_product->id)}}</td>
                                <td class="text-center">{{convert($carts_product->cart_id)}}</td>
                                <td class="text-center"><a href="{{$product->dashboardPath()}}">{{$product->name}}</a></td>
                                <td class="text-center">{{convert($carts_product->qty)}}</td>
                                <td class="text-center">{{convert(priceFormat($carts_product->discount_sell_price))}} تومان</td>
                                <td class="text-center" style="direction: ltr">{{convert($jdate->forge(strtotime($carts_product->created_at))->format('Y/m/d'))}}</td>
                            </tr>
                        @endforeach
                    @endisset
                    </tbody>
                </table>
            </div>

            <div style="margin: 5px 10px 5px 10px">
                <div class="col-sm-6 text-left">
                    @if(sizeof($carts_products)>0)
                        <span>نمایش</span>
                        @php
                            $page=isset($_GET['page']) ? $_GET['page'] : 1;
                            $count=count($carts_products);
                            $a=ceil($carts_products->total()/$carts_products->lastPage());
                        @endphp
                        <span class="iransans">{{($carts_products->currentpage()-1)*$carts_products->perpage()+1}} </span>
                        <span> الی </span>
                        @if($count<$a)
                            <span class="iransans"> {{$carts_products->total()}} </span>
                        @else
                            <span class="iransans">{{$count*$page}} </span>
                        @endif
                        <span>کالا</span>
                        <span> از </span>
                        <span class="iransans"> {{ $carts_products->total() }} </span>
                        <span>(</span>
                        <span class="iransans"> {{ $carts_products->lastPage() }} </span>
                        <span> صفحه)</span>
                    @endif
                </div>
                <div class="col-sm-6 text-right">  {!! $carts_products->links() !!}</div>
            </div>
        </div>
    </div>

@endsection

@section('modal')
    <!-- Add Modal for eye -->
    <div class="modal fade" id="modal-user-detail" tabindex="-1" role="dialog" aria-labelledby="myModalLabel"
         aria-hidden="true">
        <div class="modal-dialog" >
            <div class="modal-content">
                <div id="modal-container">

                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">×</span>
                        </button>
                        <h6 class="modal-title font-blue-ebonyclay bold" id="myModalLabel" >جزئیات حساب کاربری</h6>
                    </div>
                    <div class="modal-body">
                        <div class="card">
                            @if(is_null($user->gender) || $user->gender == 1)
                                <img src="{{asset('CRM_Assets/assets/layouts/layout/img/profile.png')}}" style="width:25%">
                            @else
                                <img src="{{asset('CRM_Assets/assets/layouts/layout/img/profile-female.png')}}" style="width:25%">
                            @endif
                            <h2 class="bold" style="color:#ff4f4f">{{$user->fname}} {{$user->lname}}</h2>
                            @if($user->role == 'admin')
                                <p class="title large font-blue"> نقش: ادمین </p>
                            @else
                                <p class="title large font-blue"> نقش: مشتری </p>
                            @endif
                            @if($user->completed == 0)
                                <p class="title large font-blue"> وضعیت حساب کاربری: تکمیل نشده </p>
                            @endif
                            <div class="pull-right" style="direction: rtl;text-align: right">
                                <p class="title">موبایل : {{convert($user->mobile)}}</p>
                                @if($user->completed == 1)
                                    @if(is_null($user->gender))
                                        <p>جنسیت :   --</p>
                                    @elseif($user->gender == 1)
                                        <p>جنسیت : مرد</p>
                                    @elseif($user->gender == 0)
                                        <p>جنسیت : زن</p>
                                    @endif
                                    <p>استان : {{$user->state}}</p>
                                    <p>شهرستان : {{$user->city}}</p>
                                    <p>آدرس : {{convert($user->address)}}</p>
                                @endif
                            </div>
                            <div class="pull-left" style="direction: rtl;text-align: right">
                                @if($user->completed == 1)
                                    <p class="title">کد ملی: {{convert($user->melli_code)}}</p>
                                    <p class="title">کد پستی: {{convert($user->postal_code)}}</p>
                                    <p>تلفن : {{is_null($user->tell)? '--':convert($user->tell)}}</p>
                                    <p>شماره تماس ضروری : {{is_null($user->urgent_phone_no)? '--':convert($user->urgent_phone_no)}}</p>
                                    <p>مجموع دفعات خرید : {{convert($user->getPaidCart(true))}} بار</p>
                                @endif
                            </div>
                            <p> <button class="btn btn-success">کل میزان خرید: {{convert(priceFormat($user->totalBuy()))}} تومان</button></p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
