@extends('/CRM/layout')

@section('script')
    <script>
        $(document).ready(function () {
            $('#permission_id').selectpicker();
        })
    </script>
@endsection
@php
    $newestItems = new \App\Models\NewestItem();
@endphp
@section('content')
    <div class="portlet light bordered main">
        @include('CRM.Admin.section.errors')
    </div>
    <div class="col-md-12 ">
        <!-- BEGIN SAMPLE FORM PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption">
                    <i class="fa fa-image"></i>
                    <span class="caption-subject font-dark sbold uppercase"> بنر نوع محصول</span>
                </div>
            </div>
            <div class="portlet-body form">
                @php($width=590)
                @php($heigt=190)

                @php($type='stuffType')

                <form class="form-horizontal" method="POST" action="{{route('banners-stuffType.update',$baner->id)}}"
                      enctype='multipart/form-data' role="form">
                    {{csrf_field()}}
                    {{method_field('PATCH')}}
                    <input type="hidden" name="width" value="{{$width}}">
                    <input type="hidden" name="heigt" value="{{$heigt}}">
                    <input type="hidden" name="type" value="{{$type}}">

                    <div class="form-body">
                        <div class="form-group ">
                            <label class="col-md-2 control-label">نوع کالا</label>
                            <div class="col-md-10">
                                <select name="stuffType_id" required class="form-control">
                                    @foreach($stuffTypes as $stuffType)
                                        <option {{$baner->stuffType_id == $stuffType->id ? 'selected' :''}} value="{{$stuffType->id}}">{{$stuffType->stuffType}}</option>
                                    @endforeach
                                </select>

                            </div>
                        </div>
                        <div class="form-group ">
                            <label class="col-md-2 control-label">نام</label>
                            <div class="col-md-10">
                                <select name="name" required class="form-control">
                                    <option {{$baner->name == 'main' ? 'selected' :''}} value="main">بنر اصلی</option>
                                </select>

                            </div>
                        </div>
                        <div class="form-group ">
                            <label class="col-md-2 control-label">عنوان</label>
                            <div class="col-md-10">
                                <input name="title" type="text" value="{{$baner->title}}"
                                       class="form-control" required placeholder="عنوان">
                            </div>
                        </div>
                        <div class="form-group ">
                            <label class="col-md-2 control-label">Url</label>
                            <div class="col-md-10">
                                <div class="input-group">
                                                            <span class="input-group-addon">
                                                                <i class="fa fa-link"></i>
                                                            </span>
                                    <input name="url" type="url" value="{{$baner->url}}"
                                           class="form-control" required
                                           placeholder="Url Address">
                                </div>
                            </div>
                        </div>
                        <div class="form-group ">
                            <div class="bgColor">
                                <div style="width: {{$width}}px;height: {{$heigt}}px" class="targetOuter">
                                    <div id="{{$type}}" class="targetLayer">

                                            <img src="{{$baner->image_path}}" width="{{$width}}px"
                                                 height="{{$heigt}}px" class="upload-preview"/>

                                    </div>
                                    <img src="{{asset('CRM_Assets/assets/pages/img/easy.png')}}"
                                         class="icon-choose-image"/>
                                    <div class="icon-choose-image">
                                        <input name="image" title="انتخاب عکس" type="file"
                                               class="inputFile userImage"
                                               onChange="showPreview(this,'#{{$type}}','{{$width}}px','{{$heigt}}px');"/>
                                    </div>
                                </div>
                                <label class="col-sm-6 control-label">سایز مناسب عکس {{$width}}x{{$heigt}}
                                    پیکسل</label>

                                <div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="form-actions">
                        <button type="submit" class="btn green">ویرایش</button>
                        <a href="{{route('banners-stuffType.index')}}" class="btn green">بازگشت</a>
                    </div>
                </form>

            </div>
        </div>
        <!-- END SAMPLE FORM PORTLET-->

    </div>
@endsection
@section('head')
    <script>
        function showPreview(objFileInput, id, w, h) {
            if (objFileInput.files[0]) {
                var fileReader = new FileReader();
                fileReader.onload = function (e) {
                    $('#blah').attr('src', e.target.result);
                    $(id).html('<img src="' + e.target.result + '" width=" ' + w + ' "; height="' + h + '" class="upload-preview" />');
                    $(".targetLayer").css('opacity', '0.7');
                    $(".icon-choose-image").css('opacity', '0.5');
                };
                fileReader.readAsDataURL(objFileInput.files[0]);
            }
        }
    </script>
@endsection