@extends('/CRM/layout')

@section('script')
    <script>
        $(document).ready(function () {
            $('#permission_id').selectpicker();
        })
    </script>
@endsection
@php
    $newestItems = new \App\Models\NewestItem();
@endphp
@section('content')
    <div class="portlet light bordered main">
        @include('CRM.Admin.section.errors')
    </div>
    <div class="col-md-12">
        <div class="col-md-6">
            <div class="col-md-12 ">
                <!-- Social baner1-->
                <div class="portlet light bordered">
                    <div class="portlet-title">
                        <div class="caption">
                            <i class="fa fa-image"></i>
                            <span class="caption-subject font-dark sbold uppercase"> بنر 1 (شبکه اجتماعی)</span>
                        </div>
                    </div>
                    <div class="portlet-body form">
                        @php($width=378)
                        @php($heigt=111)
                        @php($name='social_baner1')
                        @php($type='social')
                        @php($baner=$baners->where('name',"$name")->first())
                        <form class="form-horizontal" method="POST" action="{{route('baners-home.store')}}"
                              enctype='multipart/form-data' role="form">
                            {{csrf_field()}}
                            <input type="hidden" name="width" value="{{$width}}">
                            <input type="hidden" name="heigt" value="{{$heigt}}">
                            <input type="hidden" name="name" value="{{$name}}">
                            <input type="hidden" name="type" value="{{$type}}">
                            <div class="form-body">
                                <div class="form-group ">
                                    <label class="col-md-2 control-label">عنوان</label>
                                    <div class="col-md-10">
                                        <input name="title" type="text" @isset($baner)value="{{$baner->title}}"
                                               @endisset class="form-control" required placeholder="عنوان">
                                    </div>
                                </div>
                                <div class="form-group ">
                                    <label class="col-md-2 control-label">Url</label>
                                    <div class="col-md-10">
                                        <div class="input-group">
                                                            <span class="input-group-addon">
                                                                <i class="fa fa-link"></i>
                                                            </span>
                                            <input name="url" type="url" @isset($baner)value="{{$baner->url}}"
                                                   @endisset class="form-control" required
                                                   placeholder="Url Address">
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group ">
                                    <div class="bgColor">
                                        <div style="width: {{$width}}px;height: {{$heigt}}px" class="targetOuter">
                                            <div id="{{$name}}" class="targetLayer">
                                                @isset($baner)
                                                    <img src="{{url('/').$baner->image_path}}" width="{{$width}}px"
                                                         height="{{$heigt}}px" class="upload-preview"/>
                                                @endisset
                                            </div>
                                            <img src="{{asset('CRM_Assets/assets/pages/img/easy.png')}}"
                                                 class="icon-choose-image"/>
                                            <div class="icon-choose-image">
                                                <input name="image" title="انتخاب عکس" type="file"
                                                       class="inputFile userImage"
                                                       onChange="showPreview(this,'#{{$name}}','{{$width}}px','{{$heigt}}px');"/>
                                            </div>
                                        </div>
                                        <label class="col-sm-6 control-label">سایز مناسب عکس {{$width}}x{{$heigt}}
                                            پیکسل</label>

                                        <div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="form-actions">
                                <button type="submit" class="btn green">ویرایش</button>
                            </div>
                        </form>

                    </div>
                </div>
                <!-- Social baner1-->
            </div>
        </div>
        <div class="col-md-6">
            <div class="col-md-12 ">
                <!-- Social baner2-->
                <div class="portlet light bordered">
                    <div class="portlet-title">
                        <div class="caption">
                            <i class="fa fa-image"></i>
                            <span class="caption-subject font-dark sbold uppercase">  بنر 2 (شبکه اجتماعی)</span>
                        </div>
                    </div>
                    <div class="portlet-body form">
                        @php($width=378)
                        @php($heigt=111)
                        @php($name='social_baner2')
                        @php($type='social')
                        @php($baner=$baners->where('name',"$name")->first())
                        <form class="form-horizontal" method="POST" action="{{route('baners-home.store')}}"
                              enctype='multipart/form-data' role="form">
                            {{csrf_field()}}
                            <input type="hidden" name="width" value="{{$width}}">
                            <input type="hidden" name="heigt" value="{{$heigt}}">
                            <input type="hidden" name="name" value="{{$name}}">
                            <input type="hidden" name="type" value="{{$type}}">
                            <div class="form-body">
                                <div class="form-group ">
                                    <label class="col-md-2 control-label">عنوان</label>
                                    <div class="col-md-10">
                                        <input name="title" type="text" @isset($baner)value="{{$baner->title}}"
                                               @endisset class="form-control" required placeholder="عنوان">
                                    </div>
                                </div>
                                <div class="form-group ">
                                    <label class="col-md-2 control-label">Url</label>
                                    <div class="col-md-10">
                                        <div class="input-group">
                                                            <span class="input-group-addon">
                                                                <i class="fa fa-link"></i>
                                                            </span>
                                            <input name="url" type="url" @isset($baner)value="{{$baner->url}}"
                                                   @endisset class="form-control" required
                                                   placeholder="Url Address">
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group ">
                                    <div class="bgColor">
                                        <div style="width: {{$width}}px;height: {{$heigt}}px" class="targetOuter">
                                            <div id="{{$name}}" class="targetLayer">
                                                @isset($baner)
                                                    <img src="{{url('/').$baner->image_path}}" width="{{$width}}px"
                                                         height="{{$heigt}}px" class="upload-preview"/>
                                                @endisset
                                            </div>
                                            <img src="{{asset('CRM_Assets/assets/pages/img/easy.png')}}"
                                                 class="icon-choose-image"/>
                                            <div class="icon-choose-image">
                                                <input name="image" title="انتخاب عکس" type="file"
                                                       class="inputFile userImage"
                                                       onChange="showPreview(this,'#{{$name}}','{{$width}}px','{{$heigt}}px');"/>
                                            </div>
                                        </div>
                                        <label class="col-sm-6 control-label">سایز مناسب عکس {{$width}}x{{$heigt}}
                                            پیکسل</label>

                                        <div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="form-actions">
                                <button type="submit" class="btn green">ویرایش</button>
                            </div>
                        </form>

                    </div>
                </div>

            </div>
        </div>
    </div>
@endsection
@section('head')
    <script>

        function showPreview(objFileInput, id, w, h) {
            if (objFileInput.files[0]) {
                var fileReader = new FileReader();
                fileReader.onload = function (e) {
                    $('#blah').attr('src', e.target.result);
                    $(id).html('<img src="' + e.target.result + '" width=" ' + w + ' "; height="' + h + '" class="upload-preview" />');
                    $(".targetLayer").css('opacity', '0.7');
                    $(".icon-choose-image").css('opacity', '0.5');
                };
                fileReader.readAsDataURL(objFileInput.files[0]);
            }
        }
    </script>
@endsection