@extends('/CRM/layout')

@section('script')
    <!-- BEGIN PAGE LEVEL PLUGINS -->
    <script src="/CRM_Assets/assets/global/scripts/datatable.js" type="text/javascript"></script>
    <script src="/CRM_Assets/assets/global/plugins/datatables/datatables.min.js" type="text/javascript"></script>
    <script src="/CRM_Assets/assets/global/plugins/datatables/plugins/bootstrap/datatables.bootstrap.js"
            type="text/javascript"></script>
    <!-- END PAGE LEVEL PLUGINS -->
    <!-- BEGIN PAGE LEVEL SCRIPTS -->
    <script src="/CRM_Assets/assets/pages/scripts/table-datatables-managed.min.js" type="text/javascript"></script>
    <!-- END PAGE LEVEL SCRIPTS -->
    <!-- bootstrap-tagsinput -->
    <script src="/CRM_Assets/assets/global/plugins/bootstrap-tagsinput/bootstrap-tagsinput.min.js"
            type="text/javascript"></script>
    <!-- bootstrap-tagsinput -->
    <script src="/CRM_Assets/ckeditor/ckeditor.js" type="text/javascript"></script>
    <script>

        var options = {
            filebrowserImageBrowseUrl: '/laravel-filemanager?type=Images',
            filebrowserImageUploadUrl: '/laravel-filemanager/upload?type=Images&_token=',
            filebrowserBrowseUrl: '/laravel-filemanager?type=Files',
            filebrowserUploadUrl: '/laravel-filemanager/upload?type=Files&_token='
        };
        CKEDITOR.replace('body', options);

    </script>

@endsection
@php
    $newestItems = new \App\Models\NewestItem();
@endphp
@section('content')
    <div class="portlet light bordered main">
        @include('CRM.Admin.section.errors')
    </div>
    <div class="col-md-12 ">
        <div class="portlet light bordered">
            <div class="portlet-body form">
                @php($width=830)
                @php($heigt=479)
                <form class="form-horizontal" method="POST" action="{{route('article.update',$article->id)}}"
                      enctype='multipart/form-data' role="form">
                    {{method_field('PATCH')}}
                    {{csrf_field()}}

                    <div class="form-body">
                        <div class="form-group">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="col-md-3 control-label">دسته بندی</label>
                                    <div class="col-md-9">
                                        <select name="category" class="form-control">
                                            @foreach($categoreis as $category)
                                                <option @if($article->category->id==$category->id) selected @endif value="{{$category->id}}">{{$category->name}}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="col-md-2 control-label">عنوان</label>
                                    <div class="col-md-10">
                                        <input name="title" type="text" class="form-control" required
                                               value="{{$article->title}}"
                                               placeholder="عنوان">
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label class="col-md-2 control-label">توضیح کوتاه</label>
                                    <div class="col-md-10">
                                        <input name="description" type="text" class="form-control" required
                                               value="{{$article->description}}"
                                               placeholder="توضیح کوتاه">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <div class="col-md-7">


                                <div class="form-group">
                                    <label class="control-label col-md-3">تگ</label>
                                    <div class="col-md-9">
                                        <input type="text" name="tags" class="form-control input-large"
                                               value="{{$article->tags}}"
                                               data-role="tagsinput" required>
                                    </div>
                                </div>


                            </div>
                            <div class="col-md-1">
                                <div class="form-group">
                                    <div class="col-md-6">
                                        <div class="md-checkbox-inline">
                                            <div class="md-checkbox">
                                                <input type="checkbox" id="checkbox2_4" name="status"
                                                       class="md-check" {{$article->status ==1 ? 'checked':'' }} >
                                                <label for="checkbox2_4">
                                                    <span class="inc"></span>
                                                    <span class="check"></span>
                                                    <span class="box"></span> انتشار </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="form-group">
                                    <div class="bgColor">
                                        <div style="width: {{$width}}px;height: {{$heigt}}px" class="targetOuter">
                                            <div id="target1" class="targetLayer">
                                                @isset($article)
                                                    <img src="{{$article->image_path}}" width="{{$width}}px"
                                                         height="{{$heigt}}px" class="upload-preview"/>
                                                @endisset
                                            </div>
                                            <img src="{{asset('CRM_Assets/assets/pages/img/easy.png')}}"
                                                 class="icon-choose-image"/>

                                            <div class="icon-choose-image">
                                                <input name="image" title="انتخاب عکس" type="file"
                                                       class="inputFile userImage"
                                                       onChange="showPreview(this,'#target1','{{$width}}px','{{$heigt}}px');"/>
                                            </div>
                                        </div>
                                        <label class="col-sm-4 control-label">سایز مناسب عکس {{$width}}x{{$heigt}}
                                            پیکسل</label>

                                        <div>
                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div>
                        <div class="form-group">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label class="col-md-2 control-label">متن مقاله</label>
                                    <div class="col-md-10">
                                        <textarea name="body">{!! $article->body !!}</textarea>
                                    </div>
                                </div>
                            </div>
                        </div>


                    </div>
                    <div class="form-actions">
                        <button type="submit" class="btn green">ویرایش</button>
                        <a class="btn red" href="{{route('article.index')}}">انصراف</a>
                    </div>
                </form>
            </div>
        </div>
    </div>



@endsection
@section('head')
    <!-- BEGIN PAGE LEVEL PLUGINS -->
    <link href="/CRM_Assets/assets/global/plugins/datatables/datatables.min.css" rel="stylesheet" type="text/css"/>
    <link href="/CRM_Assets/assets/global/plugins/datatables/plugins/bootstrap/datatables.bootstrap-rtl.css"
          rel="stylesheet" type="text/css"/>
    <link href="/CRM_Assets/assets/global/plugins/bootstrap-tagsinput/bootstrap-tagsinput.css"
          rel="stylesheet" type="text/css"/>

    <!-- END PAGE LEVEL PLUGINS -->

    @if (alert()->ready())
        <script>
            $(document).ready(function () {
                swal({
                    title: "{!! alert()->message() !!}",
                    text: "{!! alert()->option('text') !!}",
                    type: "{!! alert()->type() !!}",
                    @if(alert()->option('timer'))
                    timer: "{!! alert()->option('timer') !!}",
                    showConfirmButton: false,
                    @endif
                });
            })
        </script>
    @endif

    <script>

        function showPreview(objFileInput, id, w, h) {
            if (objFileInput.files[0]) {
                var fileReader = new FileReader();
                fileReader.onload = function (e) {
                    $('#blah').attr('src', e.target.result);
                    $(id).html('<img src="' + e.target.result + '" width=" ' + w + ' "; height="' + h + '" class="upload-preview" />');
                    $(".targetLayer").css('opacity', '0.7');
                    $(".icon-choose-image").css('opacity', '0.5');
                };
                fileReader.readAsDataURL(objFileInput.files[0]);
            }
        }
    </script>
@endsection
