@extends('/CRM/layout')

@section('script')


@endsection
@php
    $newestItems = new \App\Models\NewestItem();
@endphp
@section('content')
    <div class="portlet light bordered main">
        @include('CRM.Admin.section.errors')
    </div>
    <div class="col-md-12 ">
        <div class="portlet light bordered">
            <div class="portlet-body form">
                <form class="form-horizontal" method="POST" action="{{route('articleCategory.update',$articleCategory->id)}}" role="form">
                    {{method_field('PATCH')}}
                    {{csrf_field()}}

                    <div class="form-body">
                        <div class="form-group">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label class="col-md-2 control-label">نام</label>
                                    <div class="col-md-10">
                                        <input name="name" type="text" class="form-control" required
                                               value="{{$articleCategory->name}}"
                                               placeholder="نام">
                                    </div>
                                </div>
                            </div>
                        </div>


                    </div>
                    <div class="form-actions">
                        <button type="submit" class="btn green">ویرایش</button>
                        <a class="btn red" href="{{route('article.index')}}">انصراف</a>
                    </div>
                </form>
            </div>
        </div>
    </div>



@endsection
@section('head')


    <!-- END PAGE LEVEL PLUGINS -->

    @if (alert()->ready())
        <script>
            $(document).ready(function () {
                swal({
                    title: "{!! alert()->message() !!}",
                    text: "{!! alert()->option('text') !!}",
                    type: "{!! alert()->type() !!}",
                    @if(alert()->option('timer'))
                    timer: "{!! alert()->option('timer') !!}",
                    showConfirmButton: false,
                    @endif
                });
            })
        </script>
    @endif


@endsection
