@extends('/CRM/layout')

@section('script')
    <!-- BEGIN PAGE LEVEL PLUGINS -->
    <script src="/CRM_Assets/assets/global/scripts/datatable.js" type="text/javascript"></script>
    <script src="/CRM_Assets/assets/global/plugins/datatables/datatables.min.js" type="text/javascript"></script>
    <script src="/CRM_Assets/assets/global/plugins/datatables/plugins/bootstrap/datatables.bootstrap.js"
            type="text/javascript"></script>
    <!-- END PAGE LEVEL PLUGINS -->
    <!-- BEGIN PAGE LEVEL SCRIPTS -->
    <script src="/CRM_Assets/assets/pages/scripts/table-datatables-managed.min.js" type="text/javascript"></script>
    <!-- END PAGE LEVEL SCRIPTS -->
    <!-- bootstrap-tagsinput -->
    <script src="/CRM_Assets/assets/global/plugins/bootstrap-tagsinput/bootstrap-tagsinput.min.js"
            type="text/javascript"></script>
    <script src="/CRM_Assets/assets/global/plugins/select2/js/select2.full.min.js" type="text/javascript"></script>
    <!-- bootstrap-tagsinput -->
    <script src="/CRM_Assets/ckeditor/ckeditor.js" type="text/javascript"></script>

    <script src="/CRM_Assets/assets/global/plugins/PersianDateTimePicker/Scripts/MdBootstrapPersianDateTimePicker/calendar.js"
            type="text/javascript"></script>
    <script src="/CRM_Assets/assets/global/plugins/PersianDateTimePicker/Scripts/MdBootstrapPersianDateTimePicker/jquery.Bootstrap-PersianDateTimePicker.js"
            type="text/javascript"></script>

    <script>

        var options = {
            filebrowserImageBrowseUrl: '/laravel-filemanager?type=Images',
            filebrowserImageUploadUrl: '/laravel-filemanager/upload?type=Images&_token=',
            filebrowserBrowseUrl: '/laravel-filemanager?type=Files',
            filebrowserUploadUrl: '/laravel-filemanager/upload?type=Files&_token='
        };
        CKEDITOR.replace('body', options);

    </script>

@endsection
@php
    $newestItems = new \App\Models\NewestItem();
@endphp
@section('content')
    <div class="portlet light bordered main">
        @include('CRM.Admin.section.errors')
    </div>
    <div class="col-md-12 ">
        <div class="portlet light bordered">
            <div class="portlet-body form">
                <form class="form-horizontal" method="POST" action="{{route('amazing.update',$amazing->id)}}"
                      enctype='multipart/form-data' role="form">
                    {{method_field('PATCH')}}
                    {{csrf_field()}}

                    <div class="form-body">
                        <div class="form-group">
                            <div class="col-md-9">
                                <div class="form-group">
                                    <label class="col-md-2 control-label">عنوان
                                        <span class="required"> * </span>
                                    </label>
                                    <div class="col-md-10">
                                        <input name="title" type="text" class="form-control" required
                                               value="{{$amazing->title}}"
                                               placeholder="عنوان">
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="col-md-2 control-label">ترتیب
                                    </label>
                                    <div class="col-md-10">
                                        <input name="order" type="number" min="1" max="100" class="form-control"
                                               required
                                               value="{{$amazing->order}}"
                                               placeholder="ترتیب">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="form-group ">
                            <div class="col-md-6">
                                <label class="col-sm-2 control-label">زمان شروع
                                    <span class="required"> * </span>
                                </label>
                                <div class="col-sm-3" style="margin:0 65px 0 19px">
                                    <div class="form-group">
                                        <label class="sr-only" for="date_tab2">تاریخ </label>
                                        <div class="input-group">
                                            <div class="input-group-addon" data-mddatetimepicker="true"
                                                 data-trigger="click"
                                                 data-targetselector="#date_tab2" data-englishnumber="true"
                                                 style="cursor: pointer;" data-mdpersiandatetimepicker=""
                                                 data-enabletimepicker="false"
                                                 data-original-title="" title=""
                                                 data-mdpersiandatetimepickershowing="false">
                                                <span class="glyphicon glyphicon-calendar"></span>
                                            </div>
                                            <input required class="form-control" type="text" id="date_tab2"
                                                   placeholder="تاریخ"
                                                   name="start"
                                                   value="{{jDate::forge($amazing->start)->format('Y/m/d')}}" readonly>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-sm-3" style="margin-left: 19px">
                                    <div class="form-group">
                                        @php($old_time = Request::old('startTime'))
                                        <select class="form-control text-center" style="direction: ltr" id="starttime"
                                                name="startTime">
                                            @for($i=1; $i<24; $i++)
                                                @if($i === 1)
                                                    <option disabled style="direction: rtl">قبل از ظهر</option>
                                                @elseif($i === 13)
                                                    <option disabled style="direction: rtl">بعد از ظهر</option>
                                                @endif
                                                @if($i<10)
                                                    <option class="text-center"
                                                            @if(isset($old_time))
                                                            @if($old_time == '0'.$i.':00:00')
                                                            selected
                                                            @endif
                                                            @endif
                                                            value="0{{$i}}:00:00"
                                                            style="direction: ltr">{{'0'.$i.' : 00'}}</option>
                                                @else
                                                    <option class="text-center"
                                                            @if(isset($old_time))
                                                            @if($old_time == $i.':00:00')
                                                            selected
                                                            @endif
                                                            @endif
                                                            value="{{$i}}:00:00"
                                                            style="direction: ltr">{{$i.' : 00'}}</option>
                                                @endif
                                            @endfor
                                            <option class="text-center" value="00:00:00" style="direction: ltr"
                                                    selected>00
                                                : 00
                                            </option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <label class="col-sm-2 control-label">زمان پایان
                                    <span class="required"> * </span>
                                </label>
                                <div class="col-sm-3" style="margin:0 65px 0 19px">
                                    <div class="form-group">
                                        <label class="sr-only" for="date_end">تاریخ </label>
                                        <div class="input-group">
                                            <div class="input-group-addon" data-mddatetimepicker="true"
                                                 data-trigger="click"
                                                 data-targetselector="#date_end" data-englishnumber="true"
                                                 style="cursor: pointer;" data-mdpersiandatetimepicker=""
                                                 data-enabletimepicker="false"
                                                 data-original-title="" title=""
                                                 data-mdpersiandatetimepickershowing="false">
                                                <span class="glyphicon glyphicon-calendar"></span>
                                            </div>
                                            <input required class="form-control" type="text" id="date_end"
                                                   placeholder="تاریخ"
                                                   name="end" value="{{jDate::forge($amazing->end)->format('Y/m/d')}}"
                                                   readonly>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-sm-3" style="margin-left: 19px">
                                    <div class="form-group">
                                        @php($old_time = Request::old('endTime'))
                                        <select class="form-control text-center" style="direction: ltr" id="endtime"
                                                name="endTime">
                                            @for($i=1; $i<24; $i++)
                                                @if($i === 1)
                                                    <option disabled style="direction: rtl">قبل از ظهر</option>
                                                @elseif($i === 13)
                                                    <option disabled style="direction: rtl">بعد از ظهر</option>
                                                @endif
                                                @if($i<10)
                                                    <option class="text-center"
                                                            @if(isset($old_time))
                                                            @if($old_time == '0'.$i.':00:00')
                                                            selected
                                                            @endif
                                                            @endif
                                                            value="0{{$i}}:00:00"
                                                            style="direction: ltr">{{'0'.$i.' : 00'}}</option>
                                                @else
                                                    <option class="text-center"
                                                            @if(isset($old_time))
                                                            @if($old_time == $i.':00:00')
                                                            selected
                                                            @endif
                                                            @endif
                                                            value="{{$i}}:00:00"
                                                            style="direction: ltr">{{$i.' : 00'}}</option>
                                                @endif
                                            @endfor
                                            <option class="text-center" value="00:00:00" style="direction: ltr"
                                                    selected>00
                                                : 00
                                            </option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label class="control-label col-md-2">محصول
                                        <span class="required"> * </span>
                                    </label>
                                    <div class="col-md-10">
                                        <select required class="form-control select2me" name="product_id">
                                            <option value="">جستوجو با نام..</option>
                                            @foreach($products as $product)
                                                <option {{ $product->id == $amazing->product_id ?'selected':'' }} value="{{$product->id}}">{{$product->id}}
                                                    : {{$product->name}}</option>
                                            @endforeach>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <div class="col-md-12">
                                        <div class="md-checkbox-inline ">
                                            <div class="md-checkbox">
                                                <input type="checkbox" id="checkbox2_4" name="status"
                                                       class="md-check" {{$amazing->status ==1 ? 'checked':'' }} >
                                                <label for="checkbox2_4">
                                                    <span class="inc"></span>
                                                    <span class="check"></span>
                                                    <span class="box"></span> وضعیت </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label class="col-md-2 control-label">توضیح کوتاه</label>
                                    <div class="col-lg-6 col-md-12 col-sm-12">
                                        <textarea required class="ckeditor"
                                                  name="description">{!! $amazing->description !!}</textarea>
                                    </div>
                                </div>
                            </div>
                        </div>


                    </div>
                    <div class="form-actions">
                        <button type="submit" class="btn green">ویرایش</button>
                        <a href="{{route('amazing.index')}}" class="btn btn-warning">بازگشت</a>
                    </div>
                </form>
            </div>
        </div>
    </div>




@endsection
@section('head')
    <!-- BEGIN PAGE LEVEL PLUGINS -->
    <link href="/CRM_Assets/assets/global/plugins/datatables/datatables.min.css" rel="stylesheet" type="text/css"/>
    <link href="/CRM_Assets/assets/global/plugins/datatables/plugins/bootstrap/datatables.bootstrap-rtl.css"
          rel="stylesheet" type="text/css"/>
    <link href="/CRM_Assets/assets/global/plugins/bootstrap-tagsinput/bootstrap-tagsinput.css"
          rel="stylesheet" type="text/css"/>
    <link href="/CRM_Assets/assets/global/plugins/select2/css/select2.min.css" rel="stylesheet" type="text/css"/>
    <link href="/CRM_Assets/assets/global/plugins/select2/css/select2-bootstrap.min.css" rel="stylesheet"
          type="text/css"/>

    <link rel="stylesheet"
          href="/CRM_Assets/assets/global/plugins/PersianDateTimePicker/Content/MdBootstrapPersianDateTimePicker/jquery.Bootstrap-PersianDateTimePicker.css"/>
    <style>
        a.title:link, a.title:visited {
            padding: 1px 6px 1px 6px;
            text-align: center;
            text-decoration: none;
            display: inline-block;
        }

        a.title:hover, a.title:active {
            color: #ED6B75;
            text-decoration: none;
        }

        .popover {
            z-index: 90000 !important;
            max-width: 290px;
            font-family: IRANSANS;
        }

        .popover-title {
            font-family: IRANSANS;
        }
    </style>

    <!-- END PAGE LEVEL PLUGINS -->

    @if (alert()->ready())
        <script>
            $(document).ready(function () {
                swal({
                    title: "{!! alert()->message() !!}",
                    text: "{!! alert()->option('text') !!}",
                    type: "{!! alert()->type() !!}",
                    @if(alert()->option('timer'))
                    timer: "{!! alert()->option('timer') !!}",
                    showConfirmButton: false,
                    @endif
                });
            })
        </script>
    @endif

    <script>

        function showPreview(objFileInput, id, w, h) {
            if (objFileInput.files[0]) {
                var fileReader = new FileReader();
                fileReader.onload = function (e) {
                    $('#blah').attr('src', e.target.result);
                    $(id).html('<img src="' + e.target.result + '" width=" ' + w + ' "; height="' + h + '" class="upload-preview" />');
                    $(".targetLayer").css('opacity', '0.7');
                    $(".icon-choose-image").css('opacity', '0.5');
                };
                fileReader.readAsDataURL(objFileInput.files[0]);
            }
        }
    </script>

@endsection
