@extends('/CRM/layout')

@section('script')
    <script>
        $(document).ready(function () {
            $('#permission_id').selectpicker();
        })
    </script>
@endsection
@php
    $accessories = new \App\Models\Accessory();
@endphp
@section('content')
    <div class="portlet light bordered main">
        @include('CRM.Admin.section.errors')
        <div class="page-header head-section">
            <h2>بنر لوازم جانبی </h2>
        </div>
        <form class="form-horizontal" role="form" action="{{ route('accessories.store') }}" method="post" enctype="multipart/form-data">
            {{ csrf_field() }}
            <div class="form-group">
                <label class="col-sm-3 control-label">دسته بندی ۱:</label>
                <div class="col-sm-9">
                    <select name="category_1" id="category_1" class="form-control input-medium">
                        @php
                        $accessory1 = $accessories->where('category_field_name', 'category_1')->where('status',1)->first();
                        @endphp
                        <option value="0">غیر فعال</option>
                        @foreach($categoriesInfo as $category)
                            <option value="{{$category->id}}"
                                    @isset($accessory1)
                                        @if($accessory1->Category->id == $category->id)
                                        selected
                                        @endif
                                    @endisset
                            >{{$loop->iteration}}- {{$category->category}} ({{$category->id}})</option>
                        @endforeach
                    </select>
                </div>
            </div>
            <div class="form-group">
                <label class="col-sm-3 control-label">دسته بندی ۲:</label>
                <div class="col-sm-9">
                    <select name="category_2" id="category_2" class="form-control input-medium">
                        @php
                            $accessory2 = $accessories->where('category_field_name', 'category_2')->where('status',1)->first();
                        @endphp
                        <option value="0">غیر فعال</option>
                        @foreach($categoriesInfo as $category)
                            <option value="{{$category->id}}"
                                    @isset($accessory2)
                                    @if($accessory2->Category->id == $category->id)
                                    selected
                                    @endif
                                    @endisset
                            >{{$loop->iteration}}- {{$category->category}} ({{$category->id}})</option>
                        @endforeach
                    </select>
                </div>
            </div>
            <div class="form-group">
                <label class="col-sm-3 control-label">دسته بندی ۳:</label>
                <div class="col-sm-9">
                    <select name="category_3" id="category_3" class="form-control input-medium">
                        @php
                            $accessory3 = $accessories->where('category_field_name', 'category_3')->where('status',1)->first();
                        @endphp
                        <option value="0">غیر فعال</option>
                        @foreach($categoriesInfo as $category)
                            <option value="{{$category->id}}"
                                    @isset($accessory3)
                                    @if($accessory3->Category->id == $category->id)
                                    selected
                                    @endif
                                    @endisset >{{$loop->iteration}}- {{$category->category}} ({{$category->id}})</option>
                        @endforeach
                    </select>
                </div>
            </div>
            <div class="form-group">
                <label class="col-sm-3 control-label">دسته بندی ۴:</label>
                <div class="col-sm-9">
                    <select name="category_4" id="category_4" class="form-control input-medium">
                        @php
                            $accessory4 = $accessories->where('category_field_name', 'category_4')->where('status',1)->first();
                        @endphp

                        <option value="0">غیر فعال</option>
                        @foreach($categoriesInfo as $category)
                            <option value="{{$category->id}}"
                                    @isset($accessory4)
                                    @if($accessory4->Category->id == $category->id)
                                    selected
                                    @endif
                                    @endisset>{{$loop->iteration}}- {{$category->category}} ({{$category->id}})</option>
                        @endforeach
                    </select>
                </div>
            </div>
            <div class="form-group">
                <label class="col-sm-3 control-label">دسته بندی ۵:</label>
                <div class="col-sm-9">
                    <select name="category_5" id="category_5" class="form-control input-medium">
                        @php
                            $accessory5 = $accessories->where('category_field_name', 'category_5')->where('status',1)->first();
                        @endphp
                        <option value="0">غیر فعال</option>
                        @foreach($categoriesInfo as $category)
                            <option value="{{$category->id}}"
                                    @isset($accessory5)
                                    @if($accessory5->Category->id == $category->id)
                                    selected
                                    @endif
                                    @endisset>{{$loop->iteration}}- {{$category->category}} ({{$category->id}})</option>
                        @endforeach
                    </select>
                </div>
            </div>
            <div class="form-group">
                <div class="col-md-offset-2 col-md-10">
                    <button type="submit" class="btn blue">ثبت</button>
                </div>
            </div>
        </form>
    </div>
    <div class="col-md-12 ">
        <!-- BEGIN SAMPLE FORM PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption">
                    <i class="fa fa-image"></i>
                    <span class="caption-subject font-dark sbold uppercase">بنر جدیدترینها</span>
                </div>
            </div>
            <div class="portlet-body form">
                @php($width=236)
                @php($heigt=343)
                @php($name='accessories')
                @php($type='home')
                @php($baner=$baners->where('name',"$name")->first())
                <form class="form-horizontal" method="POST" action="{{route('baners-home.store')}}"
                      enctype='multipart/form-data' role="form">
                    {{csrf_field()}}
                    <input type="hidden" name="width" value="{{$width}}">
                    <input type="hidden" name="heigt" value="{{$heigt}}">
                    <input type="hidden" name="name" value="{{$name}}">
                    <input type="hidden" name="type" value="{{$type}}">

                    <div class="form-body">
                        <div class="form-group ">
                            <label class="col-md-2 control-label">عنوان</label>
                            <div class="col-md-10">
                                <input name="title" type="text" @isset($baner)value="{{$baner->title}}"
                                       @endisset class="form-control" required placeholder="عنوان">
                            </div>
                        </div>
                        <div class="form-group ">
                            <label class="col-md-2 control-label">Url</label>
                            <div class="col-md-10">
                                <div class="input-group">
                                                            <span class="input-group-addon">
                                                                <i class="fa fa-link"></i>
                                                            </span>
                                    <input name="url" type="url" @isset($baner)value="{{$baner->url}}"
                                           @endisset class="form-control" required
                                           placeholder="Url Address">
                                </div>
                            </div>
                        </div>
                        <div class="form-group ">
                            <div class="bgColor">
                                <div style="width: {{$width}}px;height: {{$heigt}}px" class="targetOuter">
                                    <div id="{{$name}}" class="targetLayer">
                                        @isset($baner)
                                            <img src="{{url('/').$baner->image_path}}" width="{{$width}}px"
                                                 height="{{$heigt}}px" class="upload-preview"/>
                                        @endisset
                                    </div>
                                    <img src="{{asset('CRM_Assets/assets/pages/img/easy.png')}}"
                                         class="icon-choose-image"/>
                                    <div class="icon-choose-image">
                                        <input name="image" title="انتخاب عکس" type="file"
                                               class="inputFile userImage"
                                               onChange="showPreview(this,'#{{$name}}','{{$width}}px','{{$heigt}}px');"/>
                                    </div>
                                </div>
                                <label class="col-sm-6 control-label">سایز مناسب عکس {{$width}}x{{$heigt}}
                                    پیکسل</label>

                                <div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="form-actions">
                        <button type="submit" class="btn green">ویرایش</button>
                    </div>
                </form>

            </div>
        </div>
        <!-- END SAMPLE FORM PORTLET-->
    </div>

@endsection
@section('footer')
    <script>
        function showPreview(objFileInput, id, w, h) {
            if (objFileInput.files[0]) {
                var fileReader = new FileReader();
                fileReader.onload = function (e) {
                    $('#blah').attr('src', e.target.result);
                    $(id).html('<img src="' + e.target.result + '" width=" ' + w + ' "; height="' + h + '" class="upload-preview" />');
                    $(".targetLayer").css('opacity', '0.7');
                    $(".icon-choose-image").css('opacity', '0.5');
                };
                fileReader.readAsDataURL(objFileInput.files[0]);
            }
        }
    </script>
@endsection