@extends('/CRM/layout')

@section('pageBar')
    <li>
        <a href="Dashboard">خانه</a>
        <i class="fa fa-circle"></i>
    </li>
    <li>
        <span>پنل مدیریت</span>
    </li>

@stop
@section('content')
    <!-- BEGIN DASHBOARD STATS 1-->
    <h1 class="page-title"> پنل مدیریت
        <br>
        <small>آمار، ارقام، گزارشات اخیر</small>
    </h1>
    <div class="row scrolable">
        <div class="col-lg-3 col-md-3 col-sm-6 col-xs-12">
            <a class="dashboard-stat dashboard-stat-v2 blue" href="{{route('comments.show')}}">
                <div class="visual">
                    <i class="fa fa-comments"></i>
                </div>
                <div class="details">
                    <div class="number"> +
                        <span data-counter="counterup" data-value="{{\App\Models\Review::all()->count()}}">{{\App\Models\Review::all()->count()}}</span>
                    </div>
                    <div class="desc bold"> کل نظرات </div>
                </div>
            </a>
        </div>
        <div class="col-lg-3 col-md-3 col-sm-6 col-xs-12">
            <a class="dashboard-stat dashboard-stat-v2 red" href="#">
                <div class="visual">
                    <i class="fa fa-bar-chart-o"></i>
                </div>
                <div class="details">
                    <div class="number">
                        <span data-counter="counterup" data-value="{{shortenNumber($profits->sum('gross_profit'))}}"></span>{{showDecimal($profits->sum('gross_profit'))}} تومان </div>
                    <div class="desc bold"> سود ناخالص کل </div>
                </div>
            </a>
        </div>
        <div class="col-lg-3 col-md-3 col-sm-6 col-xs-12">
            <a class="dashboard-stat dashboard-stat-v2 green" href="{{route('orders.show')}}">
                <div class="visual">
                    <i class="fa fa-shopping-cart"></i>
                </div>
                <div class="details">
                    <div class="number"> +
                        <span data-counter="counterup" data-value="{{count($orders->where('paid',1)->get())}}">{{count($orders->where('paid',1)->get())}}</span>
                    </div>
                    <div class="desc bold"> کل سفارشات </div>
                </div>
            </a>
        </div>
        <div class="col-lg-3 col-md-3 col-sm-6 col-xs-12">
            <a class="dashboard-stat dashboard-stat-v2 purple" href="{{route('product.index')}}">
                <div class="visual">
                    <i class="fa fa-globe"></i>
                </div>
                <div class="details">
                    <div class="number"> +
                        <span data-counter="counterup" data-value="{{$inventoryQty}}">{{$inventoryQty}}</span> عدد </div>
                    <div class="desc bold">کالای انبار </div>
                </div>
            </a>
        </div>
    </div>
    <div class="clearfix"></div>
    <!-- END DASHBOARD STATS 1-->
    @include('errors.formAlert')
    <div class="row">
        <div class="col-lg-6 col-xs-12 col-sm-12">
            @if(Auth::user()->can(['همه','سوابق سیستم','سوابق فروش']))
                <div class="portlet light bordered">
                    <div class="portlet-title tabbable-line">
                        <div class="caption">
                            <i class="icon-bubbles font-dark hide"></i>
                            <span class="caption-subject font-dark bold">آخرین فروشها</span>
                        </div>
                        <ul class="nav nav-tabs">
                            <li>
                                <button class="btn btn-outline red-haze" data-toggle="collapse" data-target="#sell-form"><i class="fa fa-filter"></i> فیلتر سوابق</button>
                            </li>
                        </ul>
                    </div>
                    @php
                        $date_from = convert(\Morilog\Jalali\jDateTime::strftime('Y/m/d', strtotime(Carbon\Carbon::now())),'en');
                    @endphp
                    <div class="portlet-body collapse" id="sell-form">
                        <div class="col-xs-12" style="background-color: #f3f3f3e6;padding-top: 15px;padding-bottom: 20px;border-bottom: 1px solid #eef1f5;margin-bottom: 10px;">
                            <div class="col-md-12">
                                <div style="margin: 0 auto 25px auto;">در فرم زیر میتوانید فروش های خود را بر اساس بازه زمانی مورد نظر فیلتر کنید</div>
                            </div>
                            <form action="{{route('sellHistory')}}" method="GET">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <div class="col-md-3">
                                            <label class="control-label">از تاریخ</label>
                                        </div>
                                        <div class="col-md-9">
                                            <div class="form-group">
                                                <label class="sr-only" for="date_tab44">تاریخ </label>
                                                <div class="input-group">
                                                    <div class="input-group-addon" data-mddatetimepicker="true" data-trigger="click" data-targetselector="#date_tab44" data-englishnumber="true" style="cursor: pointer;" data-mdpersiandatetimepicker="" data-enabletimepicker="false" data-mdpersiandatetimepickerselecteddatetime="{&quot;Year&quot;:1396,&quot;Month&quot;:12,&quot;Day&quot;:9,&quot;Hour&quot;:0,&quot;Minute&quot;:0,&quot;Second&quot;:0}" data-original-title="" title="" data-mdpersiandatetimepickershowing="false">
                                                        <span class="glyphicon glyphicon-calendar"></span>
                                                    </div>
                                                    <input class="form-control" id="date_tab44" placeholder="تاریخ" name="from" value="{{old('from',$date_from)}}" readonly type="text">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <div class="col-md-3">
                                            <label class="control-label">تا تاریخ</label>
                                        </div>
                                        <div class="col-md-9">
                                            <div class="form-group">
                                                <label class="sr-only" for="date_tab55">تاریخ </label>
                                                <div class="input-group">
                                                    <div class="input-group-addon" data-mddatetimepicker="true" data-trigger="click" data-targetselector="#date_tab55" data-englishnumber="true" style="cursor: pointer;" data-mdpersiandatetimepicker="" data-enabletimepicker="false" data-mdpersiandatetimepickerselecteddatetime="{&quot;Year&quot;:1396,&quot;Month&quot;:12,&quot;Day&quot;:9,&quot;Hour&quot;:0,&quot;Minute&quot;:0,&quot;Second&quot;:0}" data-original-title="" title="" data-mdpersiandatetimepickershowing="false">
                                                        <span class="glyphicon glyphicon-calendar"></span>
                                                    </div>
                                                    <input class="form-control" id="date_tab55" placeholder="تاریخ" name="to" value="{{old('to',$date_from)}}" readonly type="text">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-12 text-center">
                                    <button type="submit" class="btn btn-outline green btn-xs" style="width: 50%;">اعمال فیلتر</button>
                                </div>
                            </form>
                        </div>
                    </div>

                    <div class="portlet-body" style="height: 533px;overflow-y: scroll;">
                        <!-- BEGIN: Comments -->
                        <div class="mt-comments">
                            @foreach($lastSells as $lastSell)
                                @php
                                    $product = $lastSell->getProduct2();
                                @endphp
                                <div class="mt-comment">
                                    <div class="mt-comment-img">
                                        <img src="{{url('/').$product->base_thumbnail_url}}" style="width: 135%;height: 135%;">
                                    </div>
                                    <div class="mt-comment-body">
                                        <div class="mt-comment-info">
                                            <span class="mt-comment-author">{{$product->name}}</span>
                                            <span class="mt-comment-date">{{persianDiffForHumans($lastSell->sell_date)}}</span>
                                        </div>
                                        <div class="mt-comment-text">تعداد:  {{convert($lastSell->qty)}} عدد </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                        <!-- END: Comments -->
                    </div>
                </div>
            @endif
        </div>
        <div class="col-lg-6 col-xs-12 col-sm-12">
            <!-- BEGIN PORTLET-->
            <div class="portlet light bordered">
                <div class="portlet-title">
                    <div class="caption">
                        <i class="icon-share font-red-sunglo hide"></i>
                        <span class="caption-subject font-dark bold uppercase">عایدی ها</span>
                        <span class="caption-helper">(گزارش کل ...)</span>
                    </div>
                </div>
                <div class="portlet-body">
                    <div id="site_activities_loading" style="display: none;">
                        <img src="//CRM_Assets/assets/global/img/loading.gif" alt="loading">
                    </div>
                    <div style="margin: 20px 0 10px 30px">
                        <div class="row">
                            <div class="col-md-3 col-sm-3 col-xs-6 text-stat" style="width: auto;border-left: 1px solid #d3d3d3;">
                                <span class="label label-sm label-success" style="padding: 2px 15px 2px 15px"> فروش : </span>
                                <p style="margin-top: 15px;">{{priceFormat($payments->sum('total'))}} تومان </p>
                            </div>
                            <div class="col-md-3 col-sm-3 col-xs-6 text-stat" style="width: auto;border-left: 1px solid #d3d3d3;">
                                <span class="label label-sm label-warning" style="padding: 2px 15px 2px 15px"> پست دریافتی: </span>
                                <p style="margin-top: 15px;">{{priceFormat($payments->sum('shipment_price'))}} تومان </p>
                            </div>
                            <div class="col-md-3 col-sm-3 col-xs-6 text-stat" style="width: auto;border-left: 1px solid #d3d3d3;">
                                <span class="label label-sm label-danger" style="padding: 2px 15px 2px 15px"> تخفیفات : </span>
                                <p style="margin-top: 15px;">{{priceFormat($payments->sum('discount'))}} تومان </p>
                            </div>
                            <div class="col-md-3 col-sm-3 col-xs-6 text-stat">
                                <span class="label label-sm label-primary" style="padding: 2px 15px 2px 15px"> پرداختی : </span>
                                <p style="margin-top: 15px;">{{priceFormat($payments->sum('payable_price'))}} تومان </p>
                            </div>
                        </div>
                    </div>
                    <div style="margin: 20px 0 10px 30px">
                        <div class="row">
                            <div class="col-md-3 col-sm-3 col-xs-6 text-stat" style="width: auto;border-left: 1px solid #d3d3d3;">
                                <span class="label label-sm label-success" style="padding: 2px 15px 2px 15px"> سود ناخالص : </span>
                                <p style="margin-top: 15px;">{{priceFormat($profits->sum('gross_profit'))}} تومان </p>
                            </div>
                            @php
                                $count = $profits->sum('qty');
                                $p_grossProfit = $profits->sum('p_gross_profit');
                                $p_grossMargin = $profits->sum('p_gross_margin');
                            @endphp
                            <div class="col-md-3 col-sm-3 col-xs-6 text-stat" style="width: auto;border-left: 1px solid #d3d3d3;">
                                <span class="label label-sm label-danger" style="padding: 2px 6px 2px 6px"> درصد سود ناخالص : </span>
                                <p style="margin-top: 15px;">
                                    @if(isset($p_grossProfit) && $count != 0)
                                        {{number_format($p_grossProfit / $count , 2, ".", ",")}} %
                                    @else
                                        0
                                    @endif
                                </p>
                            </div>
                            <div class="col-md-3 col-sm-3 col-xs-6 text-stat" style="width: auto;border-left: 1px solid #d3d3d3;">
                                <span class="label label-sm label-primary" style="padding: 2px 15px 2px 15px"> حاشیه سود : </span>
                                <p style="margin-top: 15px;">
                                    @if(isset($p_grossMargin) && $count != 0)
                                        {{number_format($p_grossMargin / $count , 2, ".", ",")}} %
                                    @else
                                        0
                                    @endif
                                </p>
                            </div>
                        </div>
                    </div>
                    <div style="margin: 20px 0 10px 30px">
                        <div class="row">
                            <div class="col-md-3 col-sm-3 col-xs-6 text-stat" style="width: auto;border-left: 1px solid #d3d3d3;">
                                <span class="label label-sm label-warning" style="padding: 2px 15px 2px 15px"> پست واقعی : </span>
                                <p style="margin-top: 15px;">{{priceFormat($post)}} تومان </p>
                            </div>
                            <div class="col-md-3 col-sm-3 col-xs-6 text-stat" style="width: auto;border-left: 1px solid #d3d3d3;">
                                <span class="label label-sm label-default" style="padding: 2px 15px 2px 15px"> هزینه پیک : </span>
                                <p style="margin-top: 15px;">{{priceFormat($peyk)}} تومان </p>
                            </div>
                            <div class="col-md-3 col-sm-3 col-xs-6 text-stat" style="width: auto;border-left: 1px solid #d3d3d3;">
                                <span class="label label-sm label-success" style="padding: 2px 15px 2px 15px"> مجموع : </span>
                                <p style="margin-top: 15px;">{{priceFormat($post + $peyk)}} تومان </p>
                            </div>
                            <div class="col-md-3 col-sm-3 col-xs-6 text-stat">
                                <span class="label label-sm label-danger" style="padding: 2px 15px 2px 15px"> مابه تفاوت هزینه پستی : </span>
                                <p style="margin-top: 15px;">{{priceFormat($payments->sum('shipment_price') - ($post + $peyk))}} تومان </p>
                            </div>
                            <div class="col-md-3 col-sm-3 col-xs-6 text-stat">
                                <span class="label label-sm label-danger" style="padding: 2px 15px 2px 15px"> سود خالص : </span>
                                <p style="margin-top: 15px;">{{priceFormat($profits->sum('gross_profit') + ($payments->sum('shipment_price') - ($post + $peyk)))}} تومان </p>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
            <!-- END PORTLET-->
        </div>
    </div>
    <div class="row">
        <div class="col-lg-12 col-xs-12 col-sm-12">
            <div class="portlet light bordered" id="orders-include">
                @include('CRM.dashboardIncludes.orders')
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-lg-6 col-xs-12 col-sm-12">
            <div class="portlet light bordered" id="carts-include" >
                @include('CRM.dashboardIncludes.confirmCart')
            </div>
        </div>
        <div class="col-lg-6 col-xs-12 col-sm-12">
            <div class="portlet light bordered" id="comments-include" >
                @include('CRM.dashboardIncludes.comments')
            </div>
        </div>
    </div>
    <!-- Add Modal for eye -->
    <div class="modal fade" id="myModalEye" tabindex="-1" role="dialog" aria-labelledby="myModalLabel"
         aria-hidden="true">
        <div class="modal-dialog" style="z-index: 100;width: 600px;">
            <div class="modal-content">
                <div id="modal-container">

                </div>
            </div>
        </div>
    </div>

@stop
@section('head')
    <link rel="stylesheet"
          href="/CRM_Assets/assets/global/plugins/PersianDateTimePicker/Content/bootstrap-theme.min.css"/>
    <link rel="stylesheet" href="/CRM_Assets/assets/global/plugins/PersianDateTimePicker/Content/MdBootstrapPersianDateTimePicker/jquery.Bootstrap-PersianDateTimePicker.css"/>

    <link rel="stylesheet" href="/jq-confirm/jquery-confirm.min.css">
@endsection
@section('script')
    <script src="/CRM_Assets/assets/global/plugins/PersianDateTimePicker/Scripts/MdBootstrapPersianDateTimePicker/calendar.js"
            type="text/javascript"></script>
    <script src="/CRM_Assets/assets/global/plugins/PersianDateTimePicker/Scripts/MdBootstrapPersianDateTimePicker/jquery.Bootstrap-PersianDateTimePicker.js"
            type="text/javascript"></script>

    <script src="/CRM_Assets/assets/global/plugins/counterup/jquery.waypoints.min.js" type="text/javascript"></script>
    <script src="/CRM_Assets/assets/global/plugins/counterup/jquery.counterup.min.js" type="text/javascript"></script>

    <script src="/jq-confirm/jquery-confirm.min.js"></script>
@endsection
@section('footer')
    @include('CRM.dashboardIncludes.dashboardScripts')
@stop