@extends('/CRM/layout')
@section('head')

    <link href="/CRM_Assets/nestable/nestable.css" rel="stylesheet">
    <style>
        .dd {

            float: left;
            width: 80%;

        }

        #nestable2 .dd-item > button::before {

            color: #000;
            font-size: 1em;
        }
    </style>
@endsection
@section('content')
    <a href="{{route('tecInfo.show',$category)}}" class="previous-a round-a" ><i class="fa fa-arrow-right"></i> بازگشت </a>

    <div class="page-header head-section">
        <h3 style="text-align: center">
            <i class="fa fa-list-ol" ></i>
            <span class="title bold" style="color:#ff4f4f">ترتیب</span> مشخصات فنی
        </h3>

    </div>
    <div id="alerts">
        @include('errors.formAlert')
    </div>
    <div class="panel panel-default">
        <div class="panel-heading">
            <form action="{{route('tecInfo.nestable.store')}}" type="post">
                {{csrf_field()}}
                <h3 class="panel-title FarsiFont">&nbsp;<button type="submit" class="btn btn-purple">ثبت تغییرات</button></h3>
                <textarea id="nestable-output" name="tecInfoOrder" style="display: none"></textarea>
                <textarea id="nestable2-output" name="tecInfoOrder2" style="display: none"></textarea>
            </form>
        </div>
        <div class="panel-body">

            <div class="panel-body col-sm-6" style="direction: ltr">
                <div class="col-sm-12 text-center">
                    <h4>مشخصات فنی غیر فعال</h4>
                </div>
                <div class="col-sm-12">
                    <div class="cf nestable-lists">
                        <div class="dd" id="nestable2" style="direction: rtl">
                            @if(count($deActiveTecInfos) === 0)
                                <div class="dd-empty"></div>
                            @else
                                <ol class="dd-list">
                                    @foreach ($deActiveTecInfos as $tecInfo)
                                        {!!   LAHelper::print_menu_editor(new \App\Models\ProductsTecInfo(),$tecInfo,0) !!}
                                    @endforeach
                                </ol>
                            @endif
                        </div>
                    </div>
                </div>
            </div>

            <div class="panel-body col-sm-6" style="direction: ltr">
                <div class="col-sm-12 text-center">
                    <h4>مشخصات فنی فعال</h4>
                </div>
                <div class="col-sm-12">
                    <div class="cf nestable-lists">
                        <div class="dd" id="nestable" style="direction: rtl">
                            @if(count($activeTecInfos) === 0)
                                <div class="dd-empty"></div>
                            @else
                                <ol class="dd-list">
                                    @foreach ($activeTecInfos as $tecInfo)
                                        {!!   LAHelper::print_menu_editor(new \App\Models\ProductsTecInfo(),$tecInfo) !!}
                                    @endforeach
                                </ol>
                            @endif

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('script')
    <script src="/CRM_Assets/nestable/jquery.nestable.js"></script>
    <script src="/CRM_Assets/nestable/functions.js"></script>
@endsection
@section('footer')
    <script>
        $('#nestable').nestable({
            maxDepth: 2
        });

        $('#nestable2').nestable({
            maxDepth: 2
        });
    </script>
@endsection
