@extends('/CRM/layout')
@section('head')
    <link href="/ui/jquery-ui.min.css" rel="stylesheet" type="text/css">
@endsection
@section('content')
    <div class="btn-group">
        <a href="{{route('tecInfo.show',$category)}}" class="btn btn-primary"><span class="glyphicon glyphicon-arrow-left"></span> <strong>بازگشت</strong> </a>
    </div>
    <div class="page-header head-section">

        <h3 style="text-align: center">
            <i class="fa fa-tag" ></i>
            تعریف مشخصات فنی<span class="title bold" style="color:#ff4f4f"> {{$category->category}} </span>
        </h3>

    </div>
    <div id="alerts">
        @if(session()->has('message') && session()->has('messageType'))
            <br>
            @if(session('messageType') == 'success')
                <div class="alert alert-success">
                    <div>{{session('message')}}</div>
                </div>
            @elseif(session('messageType') == 'failure')
                <div class="alert alert-danger">
                    <div>{{session('message')}}</div>
                </div>
            @endif
        @endif
        @if(count($errors) > 0)
            @php
                $hasError = true;
            @endphp
            <div class="alert alert-danger">
                <ul>
                    @foreach($errors->all() as $error)
                        <li>{{$error}}</li>
                    @endforeach
                </ul>
            </div>

        @else
            @php
                $hasError = false;
            @endphp
        @endif
    </div>
    <div class="panel panel-default">
        <div class="panel-heading">
            <h3 class="panel-title FarsiFont"><i class="fa fa-plus"></i>
                <button type="button" class="btn btn-purple" onclick="addNewItem()" id="addBtn">افزودن فیلدهای بیشتر</button>
            </h3>
        </div>
        @php
            if (session()->has('stuffs')){
             $count = count(session('stuffs'));
             $stuffs = session('stuffs');
            }else{
             $count = 1;
            }
        @endphp
        <div class="panel-body">
            <form method="post" action="{{route('tecInfo.add.store',$category)}}" id="addOrder">
                {{csrf_field()}}
                @for( $i=0 ; $i < $count ; $i++)
                    <div class="row">
                        <p class="form-group col-sm-8">
                            <input type="text" class="form-control" id="{{$i}}[tec]" name="{{$i}}[tec]" placeholder="عنوان مشخصات فنی"
                                   @if(isset($stuffs))
                                   value="{{ $stuffs[$i]['tec']}}"
                                    @endif
                            >
                        </p>
                        @if( $i != 0)
                            <p class="col-sm-2">
                                <button type="button" class="btn btn-danger deleteInput">حذف</button>
                            </p>
                        @endif
                        <hr class="visible-xs-block">
                    </div>
                @endfor
                <button type='submit' class='btn btn-success' id='sendBtn'>ثبت اطلاعات</button>
            </form>
        </div>
    </div>

@endsection
@section('script')


@endsection
@section('footer')

    <script src="/ui/jquery-ui.min.js"></script>
    <script>

        $(document).on('click', ".deleteInput", function () {
            $(this).parents('div').first().remove();
        });


        var id =  "{{$count}}";
        function addNewItem(){
            var div1 = $("<div class='row'></div>");

            var inputGroup1 = $("<p class='form-group col-sm-8'></p>");
            inputGroup1.html("<input type='text' placeholder='عنوان مشخصات فنی' class='form-control' id='" + id + "[tec]' name='" + id +"[tec]' >");


            var inputGroup3 = $("<p class='col-sm-2'></p>");
            inputGroup3.html("<button type='button' class='btn btn-danger deleteInput' style=' margin-top: 0em'>حذف</button>");

            var lineBreak = $("<hr class='visible-xs-block'>");

            div1.append(inputGroup1,inputGroup3,lineBreak);
            $("#sendBtn").before(div1);

            id++;
        }
    </script>

@endsection