@extends('/CRM/layout')
@section('content')
    <div class="page-header head-section">
        <div class="btn-group" style=" margin-right: 5px">
            <a href="{{route('size.show',$size->Category)}}" class="btn btn-sm btn-primary"><i class="fa fa-arrow-right"></i> بازگشت </a>
        </div>
        <h3 style="text-align: center">
            <i class="fa fa-tag" ></i>
            ویرایش <span class="title bold" style="color:#ff4f4f">{{$size->name}} </span>
        </h3>
    </div>
    <div id="alerts">
        @include('errors.formAlert')
    </div>
    <div class="panel panel-default">
        <div class="panel-heading">
            <h3 class="panel-title FarsiFont"><i class="fa fa-list"></i>&nbsp;ویرایش سایز</h3>
        </div>
        <div class="panel-body">
            <div class="col-sm-8">
                <form class="form-horizontal" id="uploadForm" action="{{route('size.update',$size)}}" role="form" method="POST" >
                    {{csrf_field()}}
                    <div class="form-group">
                        <label class="col-sm-3 control-label">عنوان سایز</label>
                        <div class="col-sm-9">
                            <input type="text" class="form-control" id="name" name="name" placeholder="عنوان سایز" value="{{$size->name or old('name')}}">
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-sm-3 control-label">دسته بندی مربوطه</label>
                        <div class="col-sm-9">
                            <select class="form-control" id="category_id" name="category_id" data-placeholder="انتخاب کنید...">
                                <option>انتخاب کنید...</option>
                                @foreach($categories as $category)
                                    <option value="{{$category->id}}"
                                            @if(!is_null(old('$category')) && old('$category') == $category->id)
                                            selected
                                            @elseif($size->category_id == $category->id)
                                            selected
                                            @endif
                                    >{{$loop->iteration}} - {{$category->category}}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-green">ثبت</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection

