@extends('/CRM/layout')
@section('head')

    <!-- BEGIN PAGE LEVEL PLUGINS -->
    <link href="/CRM_Assets/assets/global/plugins/datatables/datatables.min.css" rel="stylesheet" type="text/css"/>
    <link href="/CRM_Assets/assets/global/plugins/datatables/plugins/bootstrap/datatables.bootstrap-rtl.css"
          rel="stylesheet" type="text/css"/>
    <!-- END PAGE LEVEL PLUGINS -->
@endsection
@section('content')
    <div class="page-header head-section">
        <div class="btn-group" style="float: left; margin-right: 5px;margin-left: 19px">
            <button class="btn btn-sm btn-primary" data-toggle="modal" title="جدید" data-target="#myModalCategory"><i class="fa fa-plus"></i> افزودن سایز </button>
        </div>
        <h3 style="text-align: center">
            <i class="fa fa-tag" ></i>
            سایز های دسته بندی <span class="title bold" style="color:#ff4f4f">{{$category->category}} </span>
        </h3>
    </div>
    <div id="alerts">
        @include('errors.formAlert')
    </div>
    <div class="panel panel-default">
        <div class="panel-heading">
            <h3 class="panel-title FarsiFont"><i class="fa fa-list"></i>&nbsp;مدیریت سایز ها</h3>
        </div>
        <div class="panel-body">
            <div id="table">
                @include('CRM.Anbar.size.allTableInclude')
            </div>
        </div>
    </div>

    <div class="modal fade" id="myModalCategory" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
        <div class="modal-dialog" style="z-index: 100;width: 600px;">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                    <h4 class="modal-title" id="myModalLabel">ایجاد سایز جدید</h4>
                </div>
                <div class="modal-body">
                    <form class="form-horizontal" id="uploadForm" action="{{route('size.store',$category)}}" role="form" method="POST">
                        {{csrf_field()}}
                        <div class="form-group">
                            <label class="col-sm-3 control-label">عنوان سایز</label>
                            <div class="col-sm-9">
                                <input type="text" class="form-control" id="name" name="name" placeholder="عنوان سایز">
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="submit" class="btn btn-green">ثبت</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>




@endsection
@section('script')


    <!-- BEGIN PAGE LEVEL PLUGINS -->
    <script src="/CRM_Assets/assets/global/scripts/datatable.js" type="text/javascript"></script>
    <script src="/CRM_Assets/assets/global/plugins/datatables/datatables.min.js" type="text/javascript"></script>
    <script src="/CRM_Assets/assets/global/plugins/datatables/plugins/bootstrap/datatables.bootstrap.js"
            type="text/javascript"></script>
    <!-- END PAGE LEVEL PLUGINS -->
    <!-- BEGIN PAGE LEVEL SCRIPTS -->
    <script src="/CRM_Assets/assets/pages/scripts/table-datatables-managed.min.js" type="text/javascript"></script>
    <!-- END PAGE LEVEL SCRIPTS -->

@endsection
