@extends('/CRM/layout')
@section('content')
    <div class="page-header head-section">
        <div class="btn-group" style=" margin-right: 5px">
            <a href="{{route('color.index')}}" class="btn btn-sm btn-primary"><i class="fa fa-arrow-right"></i> بازگشت </a>
        </div>
        <h3 style="text-align: center">
            <i class="fa fa-eyedropper" ></i>
            ویرایش رنگ <span class="title bold" style="color:{{'#'.$color->colorCode}}">{{$color->colorName}} </span>
        </h3>
    </div>
    <div id="alerts">
        @include('errors.formAlert')
    </div>
    <div class="panel panel-default">
        <div class="panel-heading">
            <h3 class="panel-title FarsiFont"><i class="fa fa-list"></i>&nbsp;ویرایش رنگ</h3>
        </div>
        <div class="panel-body">
            <div class="col-sm-8">
                <form class="form-horizontal" id="uploadForm" action="{{route('color.update',$color)}}" role="form" method="POST" >
                    {{csrf_field()}}
                    {{method_field('PATCH')}}
                    <div class="form-group">
                        <label class="col-sm-3 control-label">عنوان رنگ</label>
                        <div class="col-sm-9">
                            <input type="text" class="form-control" id="colorName" name="colorName" placeholder="عنوان رنگ" value="{{$color->colorName or old('colorName')}}">
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-sm-3 control-label" for="colorCode">انتخاب رنگ</label>
                        <div class="col-sm-9">
                            <input class="form-control input-circle jscolor" id="colorCode" name="colorCode" value="{{$color->colorCode or old('colorCode')}}" type="text"> </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-success">ثبت</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection

@section('script')
    <script src="/jscolor/jscolor.js"></script>
@stop