@extends('/CRM/layout')

@section('head')
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <style>
        .mt-comments a {
            text-decoration: none!important;
        }
        .mt-comments a:hover {
            color:#FF4F4F!important;
        }
    </style>

@stop

@section('pageBar')
    <li>
        <a href="/CRM/Dashboard">داشبورد</a>
        <i class="fa fa-circle"></i>
    </li>
    <li>
        <span>انبار</span>
        <i class="fa fa-circle"></i>
    </li>
    <li>
        <span>تنظیمات اطلاعات پایه</span>
    </li>
@stop

@section('content')

    @if(session()->has('message') && session()->has('messageType'))
        <br>
        @if(session('messageType') == 'success')
            <div class="alert alert-success">
                <p>{{session('message')}}</p>
            </div>
        @elseif(session('messageType') == 'failure')
            <div class="alert alert-danger">
                <p>{{session('message')}}</p>
            </div>
        @endif
    @endif


    <div class="portlet light ">
        <div class="portlet-title tabbable-line border-green-soft">
            <div class="caption">
                <i class="icon-bubbles font-dark hide"></i>
                <span class="caption-subject dark bold"><i class="fa fa-cogs"></i> تنظیمات اطلاعات پایه کالا</span>
                <br>
            </div>
            <br>
            <br>
            <small  class="font-red-thunderbird" >قبل از اینکه از دیگر امکانات انبار استفاده کنید، باید کالا و اطلاعات آن را در سیستم تعریف کنید</small>
            <br>
            <br>
        </div>
        <div class="portlet-body">
            <div class="tab-content">
                <div class="tab-pane active" id="portlet_comments_1">
                    <!-- BEGIN: Comments -->
                    <div class="mt-comments">
                        @if(Auth::user()->can(['اطلاعات پایه کالا','همه','تعریف نوع کالا','تعریف دسته بندی','تعریف مشخصات فنی','تعریف سایز']))
                            <a href="{{url('/CRM/createStuffType')}}">
                                <div class="mt-comment">
                                    <div class="mt-comment-img">
                                        <span class="glyphicon glyphicon-phone"></span>
                                    </div>
                                    <div class="mt-comment-body">
                                        <div class="mt-comment-info">
                                            <span class="mt-comment-author">تعریف نوع کالا</span>
                                        </div>
                                        <div class="mt-comment-text">در این بخش نوع کالاها در سیستم تعریف می شود. (مثال: کالای دیجیتال، لباس و ...) </div>
                                    </div>
                                </div>
                            </a>
                            <hr>
                        @endif
                            @if(Auth::user()->can(['اطلاعات پایه کالا','همه','تعریف دسته بندی','تعریف مشخصات فنی','تعریف سایز']))
                            <a href="{{route('category.show')}}">
                                <div class="mt-comment">
                                    <div class="mt-comment-img">
                                        <i class="fa fa-tag"></i>
                                    </div>
                                    <div class="mt-comment-body">
                                        <div class="mt-comment-info">
                                            <span class="mt-comment-author">تعریف دسته بندی / مشخصات فنی/ تعریف سایز </span>
                                        </div>
                                        <div class="mt-comment-text">در این بخش نوع کالاها در سیستم تعریف می شود. (مثال: کالای دیجیتال، لباس و ...) </div>
                                    </div>
                                </div>
                            </a>
                            <hr>
                        @endif
                            @if(Auth::user()->can(['اطلاعات پایه کالا','همه','تعریف برند']))
                            <a href="{{url('CRM/createBrand')}}">
                                <div class="mt-comment">
                                    <div class="mt-comment-img">
                                        <i class="fa fa-apple" aria-hidden="true"></i>
                                    </div>
                                    <div class="mt-comment-body">
                                        <div class="mt-comment-info">
                                            <span class="mt-comment-author">تعریف برند کالا </span>
                                        </div>
                                        <div class="mt-comment-text">در این بخش نام برند کالاها در سیستم تعریف می شود. (مثال: اپل، سامسونگ و ...)</div>
                                    </div>
                                </div>
                            </a>
                            <hr>
                        @endif
                        {{--@if(Auth::user()->can(['تنظیمات اولیه','اطلاعات پایه کالا','همه','تعریف کالا']))--}}
                            {{--<a href="{{route('stuff.show')}}">--}}
                                {{--<div class="mt-comment">--}}
                                    {{--<div class="mt-comment-img">--}}
                                        {{--<i class="fa fa-cubes" ></i>--}}
                                    {{--</div>--}}
                                    {{--<div class="mt-comment-body">--}}
                                        {{--<div class="mt-comment-info">--}}
                                            {{--<span class="mt-comment-author">تعریف کالا</span>--}}
                                        {{--</div>--}}
                                        {{--<div class="mt-comment-text">در این بخش نام کالاها در سیستم تعریف می شود.(مثال: آیفون 5s، اچ پی 4530 و ...) </div>--}}
                                    {{--</div>--}}
                                {{--</div>--}}
                            {{--</a>--}}
                            {{--<hr>--}}
                        {{--@endif--}}
                        @if(Auth::user()->can(['تنظیمات اولیه','اطلاعات پایه کالا','همه','تعریف رنگ']))
                            <a href="{{route('color.index')}}">
                                <div class="mt-comment">
                                    <div class="mt-comment-img">
                                        <span class="fa fa-eyedropper"></span>
                                    </div>
                                    <div class="mt-comment-body">
                                        <div class="mt-comment-info">
                                            <span class="mt-comment-author">تعریف رنگ </span>
                                        </div>
                                        <div class="mt-comment-text">در این بخش رنگ کالاها در سیستم تعریف می شود. </div>
                                    </div>
                                </div>
                            </a>
                        @endif
                    </div>
                    <!-- END: Comments -->
                </div>
            </div>
        </div>
    </div>
@stop
@section('footer')

    <script src="/ui/jquery-ui.min.js"></script>


@stop