@extends('/CRM/layout')

@section('head')
    <link href="/css/main.css" rel="stylesheet" type="text/css">
    <link href="/ui/jquery-ui.min.css" rel="stylesheet" type="text/css">
    <link href="/jq-dropzone/dropzone.min.css" rel="stylesheet">
    <meta name="csrf-token" content="{{ csrf_token()}}">
    <link rel="stylesheet" href="/jq-confirm/jquery-confirm.min.css">

    <style>
        #description-output, #review-output, #tecInfo-output {
            width: 100%;
            height: 200px;
            overflow: hidden;
            text-overflow: ellipsis;
        }

        /*#image_wraper{*/
        /*width: 100%;*/
        /*height: 900px;*/
        /*overflow: hidden;*/
        /*text-overflow: ellipsis;*/
        /*}*/

    </style>
@stop

@section('pageBar')
    <li>
        <a href="Dashboard">خانه</a>
        <i class="fa fa-circle"></i>
    </li>
    <li>
        <span>انبار</span>
        <i class="fa fa-circle"></i>
    </li>
    <li>
        <span>محصولات</span>
    </li>
@stop
@section('pageTitle')

    <div class="col-xs-12">

        <a href="{{route('product.index')}}" class="previous-a round-a"><span
                    class="glyphicon glyphicon-arrow-left"></span><strong> بازگشت </strong> </a>
    </div>

    <div class="col-xs-12 text-center">
        <h1 class="page-title" style="font-size: 20px"> مشخصات محصول {{$product->name}}</h1>
    </div>

@stop
@section('content')
    <div class="col-md-12">
        <div class="portlet light bordered" id="form_wizard_1">
            @include('errors.formAlert')
            <div class="portlet-body form">
                <div class="form-horizontal">
                    <div class="tab-pane">
                        <div class="form-actions">
                            <div class="row">
                                <div class="col-xs-4">
                                    <div class="col-xs-6">
                                        <div class="btn-group">
                                            <a href="{{route('product.edit',$product)}}"
                                               class="btn btn-primary mt-ladda-btn ladda-button btn-circle"><i
                                                        class="fa fa-pencil" aria-hidden="true"></i> ویرایش مشخصات </a>
                                        </div>
                                    </div>
                                    <div class="col-xs-6">

                                        <div class="btn-group">
                                            <a href="{{route('product.tecInfo.index',$product)}}"
                                               class="btn btn-circle green-dark"><i class="fa fa-check-circle"
                                                                                    aria-hidden="true"></i> مشخصات فنی
                                            </a>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xs-6">
                                    <div class="wrapper_left">
                                        <div class="btn-group">
                                            <button class="btn btn-circle green" onclick="dropzoneToggle()"><i
                                                        class="fa fa-picture-o" aria-hidden="true"></i> آپلود عکس
                                            </button>
                                        </div>
                                        <br>
                                        <br>
                                        <div class="container" id="dropzone" style="display: none;">
                                            <div class="row">
                                                <div class="col-md-5">
                                                    <p class="small"> برای آبلود عکس، عکس های خود را به این محل
                                                        بیاندازید(یا بر روی آن کلیک کنید): </p>
                                                    <form action="/CRM/imageUpload" enctype='multipart/form-data'
                                                          class="dropzone" method="POST" id="image-upload">
                                                        <input type="hidden" name="_token" id="token"
                                                               value="{{ csrf_token() }}">
                                                        <input type="hidden" name="id_product" value="{{$product->id}}">
                                                        <div class="fallback">
                                                            <input name="photo" type="file" multiple>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-6" id="info_wraper">
                            <h3 class="widget-title-color-blue bold">{{$product->name}}</h3>
                            <h4 class="widget-title-color-red small bold">{{$product->eng_name}}</h4>
                            <h3 class="block">مشخصات محصول</h3>
                            <p class="btn btn-circle purple">مشخصات پایه</p>
                            <div class="form-group">
                                <label class="control-label col-md-4">کد کالا:</label>
                                <div class="col-md-8 grey_info">
                                    <p class="form-control-static"
                                       id="product-output">{{$product->productsColor()->first()->code}} </p>
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="control-label col-md-4">نوع کالا:</label>
                                <div class="col-md-8 pink_info">
                                    <p class="form-control-static"
                                       id="category-output">{{$product->StuffType->stuffType}} </p>
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="control-label col-md-4">دسته بندی:</label>
                                <div class="col-md-8 grey_info">
                                    <p class="form-control-static"
                                       id="category-output">{{$product->Category->category}} </p>
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="control-label col-md-4">برند:</label>
                                <div class="col-md-8 pink_info">
                                    <p class="form-control-static" id="brand-output">{{$product->Brand->brandName}} </p>
                                </div>
                            </div>

                            <div class="form-group">
                                <label class="control-label col-md-4">بهای تمام شده:</label>
                                <div class="col-md-8 grey_info">
                                    <p class="form-control-static" id="buy">{{convert(priceFormat($product->buy))}}
                                        تومان</p>
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="control-label col-md-4">قیمت فروش پایه:</label>
                                <div class="col-md-8 grey_info">
                                    <p class="form-control-static"
                                       id="base_sell_price-output">{{convert(priceFormat($product->base_sell_price))}}
                                        تومان</p>
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="control-label col-md-4">قیمت فروش با تخفیف:</label>
                                <div class="col-md-8 pink_info">
                                    <p class="form-control-static" id="discount_sell_price-output">
                                        @if(!is_null($product->discount_sell_price))
                                            {{ convert(priceFormat($product->discount_sell_price))}} تومان
                                        @else
                                            ندارد
                                        @endif
                                    </p>
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="control-label col-md-4">تعداد کالا:</label>
                                <div class="col-md-8 grey_info">
                                    <p class="form-control-static" id="alarm_level-output">{{$product->qty}} </p>
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="control-label col-md-4">سطح هشدار:</label>
                                <div class="col-md-8 pink_info">
                                    <p class="form-control-static"
                                       id="alarm_level-output">{{$product->alarm_level}} </p>
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="control-label col-md-4">وزن (گرم):</label>
                                <div class="col-md-8 grey_info">
                                    <p class="form-control-static" id="alarm_level-output">{{$product->weight}} </p>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-6">
                            <div class="form-actions">
                                <div class="row">
                                    {{--<div class="col-md-12">--}}
                                    {{--<div class="btn-group">--}}
                                    {{--<a href="{{route('product.color.index',$product)}}" class="btn btn-circle red"><i class="fa fa-eyedropper" aria-hidden="true"></i>--}}
                                    {{--تعیین--}}
                                    {{--@if($product->Category->type == 0)--}}
                                    {{--رنگ--}}
                                    {{--@elseif($product->Category->type == 1)--}}
                                    {{--سایز--}}
                                    {{--@elseif($product->Category->type == 2)--}}
                                    {{--رنگ و سایز--}}
                                    {{--@endif--}}
                                    {{--</a>--}}
                                    {{--<br>--}}
                                    {{--<br>--}}
                                    {{--<div class="actions" id="color_wraper">--}}
                                    {{--@include("CRM.Anbar.Product.productColor")--}}
                                    {{--</div>--}}
                                    {{--</div>--}}
                                    {{--</div>--}}
                                    <div class="col-md-12" id="image_wraper">
                                        <div id="image_area">
                                            @include("CRM.Anbar.Product.productImageGallery")
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="portlet box blue ">
                <div class="portlet-title">
                    <div class="caption">
                        <i class="fa fa-pencil"></i> اضافه کردن pdf
                    </div>
                    <div class="tools">
                        <a href="" class="collapse"> </a>

                    </div>
                </div>
                <div class="portlet-body form">
                    <form class="form-horizontal" method="POST" action="{{route('product.pdf.store',$product)}}"
                          enctype='multipart/form-data' role="form">

                        {{csrf_field()}}

                        <div class="form-body">
                            <div class="form-group">

                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="col-md-2 control-label">عنوان</label>
                                        <div class="col-md-10">
                                            <input name="title" type="text" class="form-control" required
                                                   value="{{old('title')}}"
                                                   placeholder="عنوان">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="col-md-2 control-label">فایل</label>
                                        <div class="col-md-10">
                                            <input name="pdf" type="file" class="form-control" required
                                                   value="{{old('pdf')}}" accept="application/pdf">
                                        </div>
                                    </div>
                                </div>

                            </div>

                        </div>
                        <div class="form-actions">
                            <button type="submit" class="btn green">ثبت</button>
                        </div>
                    </form>
                </div>

                @if(!$product->pdfs->isEmpty())
                    @foreach($product->pdfs as $pdf)
                        <div class="col-md-3">{{$pdf->title}}</div>
                        @endforeach
                    @endif
            </div>

            <div class="portlet box blue ">
                <div class="portlet-title">
                    <div class="caption">
                        <i class="fa fa-pencil"></i>لیست فایل ها
                    </div>
                </div>

                @if(!$product->pdfs->isEmpty())
                    @foreach($product->pdfs as $pdf)
                        <div class="col-md-3 btn btn-default margin-top-10">{{$pdf->title}}
                        <form method="post" action="{{route('product.pdf.destroy',$pdf)}}">
                            {{csrf_field()}}
                            <button><i class="fa fa-trash text-danger"></i> </button>
                        </form>
                        </div>
                    @endforeach
                @endif
            </div>

        </div>
    </div>
@stop

@section('script')
    <script src="/jq-confirm/jquery-confirm.min.js"></script>
    <script src="/jq-dropzone/dropzone.min.js"></script>
@stop

@section('footer')


    <script src="/ui/jquery-ui.min.js"></script>

    <script type="text/javascript">
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });
        /****************dropzoneAjax*****************/
        Dropzone.options.imageUpload = {
            paramName: "photo",
            parallelUploads: 2,
            maxFilesize: 10,
            acceptedFiles: ".jpeg,.jpg,.png,.gif",
            success:
                function (file, response) {
                    $("#image_area").html(response);
                    $('#dropzone').hide();
                    this.removeFile(file);
                }
        };

        /****************dropzoneToggle*****************/
        function dropzoneToggle() {
            $('#dropzone').toggle();
        }

        /****************base image select*****************/
        function makeBaseImage() {

            $.confirm({
                title: 'انتخاب عکس به عنوان عکس اصلی',
                content: 'آیا مطمئن هستید؟',
                buttons: {
                    somethingElse: {
                        text: 'تایید',
                        btnClass: 'btn-blue',
                        action: function () {
                            var imageUrl = $('#modal-button').data();
                            $.ajax({
                                url: "/CRM/pickBaseImage",
                                type: "POST",
                                cash: false,
                                data: {imageUrl: imageUrl, _token: $('#token').val()},
                                success:
                                    function (response) {
                                        $("#image_area").html(response);
                                        swal({
                                            title: "انتخاب شد",
                                            text: "عکس مورد نظر به عنوان عکس اصلی انتخاب شد",
                                            type: "success",
                                            showConfirmButton: false,
                                            timer: 1500

                                        });
                                    }
                            });

                        }
                    },
                    somethingElse2: {
                        text: 'خیر',
                        btnClass: 'btn-red',
                        action: function () {
                            swal({
                                title: "تایید نشد",
                                type: "info",
                                showConfirmButton: false,
                                timer: 800

                            });

                        }
                    }
                }
            });
        }

        /****************modal image show*****************/
        $(document).on('click', ".myImg", function () {
            $('#myModal').css('display', 'block');
            $("#modal-button").attr("data-content", this.src);
            $("#img01").attr("src", this.src);
            $("#caption").html(this.alt);
        });
        $(document).on('click', '.close-image', function () {
            $('#myModal').css('display', 'none')
        });
        /****************base modal image show*****************/
        $(document).on('click', '.myImgBase', function () {
            $('#myModalBase').css('display', 'block');
            $("#img01Base").attr("src", this.src);
            $("#captionBase").html(this.alt);
        });

        $(document).on('click', '.close-imageBase', function () {
            $('#myModalBase').css('display', 'none')
        });

        /******************colorDeletAjax***************/
        function deleteColor(productColorId) {
            $.confirm({
                title: 'حذف رنگ از محصول',
                content: 'آیا مطمئن هستید؟',
                buttons: {
                    somethingElse: {
                        text: 'تایید',
                        btnClass: 'btn-blue',
                        action: function () {
                            $.ajax({
                                url: "/CRM/deleteProductColor",
                                type: "POST",
                                cash: false,
                                data: {productColorId: productColorId, _token: $('#token').val()},
                                success:
                                    function (response) {
                                        $('#color_wraper').html(response);
                                        swal({
                                            title: "حذف شد",
                                            text: "رنگ مورد نظر با موفقیت حذف شد",
                                            type: "success",
                                            showConfirmButton: false,
                                            timer: 1100

                                        });
                                    }
                            })
                        }
                    },
                    somethingElse2: {
                        text: 'خیر',
                        btnClass: 'btn-red',
                        action: function () {
                            swal({
                                title: "تایید نشد",
                                type: "info",
                                showConfirmButton: false,
                                timer: 800

                            });

                        }
                    }
                }
            });
        }

        /*****************photoDelete*******************/
        function deletePhoto(photoId) {
            $.confirm({
                title: 'حذف عکس از گالری محصول',
                content: 'آیا مطمئن هستید؟',
                buttons: {
                    somethingElse: {
                        text: 'تایید',
                        btnClass: 'btn-blue',
                        action: function () {
                            $.ajax({
                                url: "/CRM/deleteImage",
                                type: "POST",
                                cash: false,
                                data: {photoId: photoId, _token: $('#token').val()},
                                success:
                                    function (response) {
                                        $("#image_area").html(response);
                                        swal({
                                            title: "حذف شد",
                                            text: "عکس مورد نظر با موفقیت حذف شد",
                                            type: "success",
                                            showConfirmButton: false,
                                            timer: 1100

                                        });

                                    }
                            })
                        }
                    },
                    somethingElse2: {
                        text: 'خیر',
                        btnClass: 'btn-red',
                        action: function () {
                            swal({
                                title: "تایید نشد",
                                type: "info",
                                showConfirmButton: false,
                                timer: 800

                            });

                        }
                    }
                }
            });

        }

        /****************tooltip**********/
        $(document).ready(function () {
            $('[data-toggle="tooltip"]').tooltip();

        });

    </script>


@stop