@extends('/CRM/layout')
@section('head')
    <link rel="stylesheet" href="/jq-confirm/jquery-confirm.min.css">
    <!-- BEGIN PAGE LEVEL PLUGINS -->
    <link href="/CRM_Assets/assets/global/plugins/datatables/datatables.min.css" rel="stylesheet" type="text/css"/>
    <link href="/CRM_Assets/assets/global/plugins/datatables/plugins/bootstrap/datatables.bootstrap-rtl.css"
          rel="stylesheet" type="text/css"/>
    <!-- END PAGE LEVEL PLUGINS -->
    {{--Data TimePiker--}}

    <link rel="stylesheet"
          href="/CRM_Assets/assets/global/plugins/PersianDateTimePicker/Content/bootstrap-theme.min.css"/>
    <link rel="stylesheet" href="/CRM_Assets/assets/global/plugins/PersianDateTimePicker/Content/MdBootstrapPersianDateTimePicker/jquery.Bootstrap-PersianDateTimePicker.css"/>
    <style>
        a.title:link, a.title:visited {
            padding: 1px 6px 1px 6px;
            text-align: center;
            text-decoration: none;
            display: inline-block;
        }

        a.title:hover, a.title:active {
            color: #ED6B75;
            text-decoration: none;
        }

        .popover {
            z-index: 90000 !important;
            max-width: 290px;
            font-family: IRANSANS;
        }

        .popover-title {
            font-family: IRANSANS;
        }


    </style>
@endsection
@section('content')
    <div class="page-header head-section">
        <h3 style="text-align: center">
            <i class="fa fa-dollar"></i>
            قیمت گذاری بر اساس <span class="title bold" style="color:#ff4f4f"> رنگ و سایز</span>
        </h3>
    </div>
    <div id="alerts">
        @include('errors.formAlert')
    </div>
    <form action="{{route('price-chunk.store')}}" method="post">
        {{csrf_field()}}
        <div class="panel panel-default">
            <div class="panel-heading">
                <h3 class="panel-title FarsiFont"><i class="fa fa-list"></i>&nbsp;
                    <button type="submit" class="btn btn-success" >بروز رسانی قیمت ها</button>
                </h3>
            </div>
            <div class="panel-body">
                <div id="table">
                    @include('CRM.Anbar.PriceChunk.allTableInclude')
                </div>
            </div>
        </div>
    </form>



@endsection
@section('script')


    <!-- BEGIN PAGE LEVEL PLUGINS -->
    <script src="/CRM_Assets/assets/global/scripts/datatable.js" type="text/javascript"></script>
    <script src="/CRM_Assets/assets/global/plugins/datatables/datatables.min.js" type="text/javascript"></script>
    <script src="/CRM_Assets/assets/global/plugins/datatables/plugins/bootstrap/datatables.bootstrap.js"
            type="text/javascript"></script>
    <!-- END PAGE LEVEL PLUGINS -->
    <!-- BEGIN PAGE LEVEL SCRIPTS -->
    <script src="/CRM_Assets/assets/pages/scripts/table-datatables-managed.min.js" type="text/javascript"></script>
    <!-- END PAGE LEVEL SCRIPTS -->


    <script src="/jq-confirm/jquery-confirm.min.js"></script>
@endsection
@section('footer')
    <script type="text/javascript">
        $(document).on('click', ".view-order", function () {
            var id = $(this).attr('data-content');
            var mode = $(this).attr('data-title');
            $.ajax({
                url: "{{route('order.view')}}",
                type: "GET",
                data: {id: id,mode : mode,status: "all"},
                success: function (data) {

                    $("#modal-container").html(data);

                },
                error: function (xhr) {
                    var error = jQuery.parseJSON(xhr.responseText);  // this section is key player in getting the value of the errors from controller.
                    var info = $('#alerts');
                    swal({
                        title: "خطا",
                        text: " با خطا مواجه شد",
                        type: "error",
                        timer: 1500
                    });
                    info.hide().empty();
                    var html = '<div class="alert alert-danger"><ul>';
                    $.each(error.errors, function (k, v) {
                        html += '<li>' + v[0] + '</li>';
                    });
                    html += '<\div><ul>';
                    info.append(html);
                    info.slideDown();
                }
            });

        });

        $(document).on('click', ".approve-order", function () {
            var id = $(this).attr('data-content');
            var mode = $(this).attr('data-title');
            var city = $(this).attr('data-option');

            if(mode == 3){
                if(city == 'ارومیه'){
                    $('#order_id_peyk').val(id);
                    $('#myModalPeyk').modal('show');
                }else {
                    $('#order_id').val(id);
                    $('#myModalPost').modal('show');
                }
            }else{
                $.confirm({
                    title: 'تایید این مرحله و انتقال به مرحله بعد',
                    content: 'آیا مطمئن هستید؟',
                    buttons: {
                        somethingElse: {
                            text: 'تایید',
                            btnClass: 'btn-blue',
                            action: function () {
                                $.ajax({
                                    url: "{{route('changeOrders')}}",
                                    type: "POST",
                                    data: {id : id,mode : mode,status: "all",_token:$('#token').val()} ,
                                    success: function(data)
                                    {
                                        $("#table").html(data);
                                        $('#myModalEye').modal('hide');
                                        swal({
                                            title: "انتقال یافت",
                                            text: "سفارش با موفقیت تایید و مرحله بعد انتفال یافت",
                                            type: "success",
                                            showConfirmButton: false,
                                            timer: 1500
                                        });
                                    },
                                    error: function(xhr) {
                                        var error = jQuery.parseJSON(xhr.responseText);  // this section is key player in getting the value of the errors from controller.
                                        var info = $('#alerts');
                                        swal({
                                            title: "خطا",
                                            text: " با خطا مواجه شد",
                                            type: "error",
                                            timer: 1500
                                        });
                                        $('#myModalEye').modal('hide');
                                        info.hide().empty();
                                        var html = '<div class="alert alert-danger"><ul>';
                                        $.each( error.errors, function( k,v ) {
                                            html+=  '<li>'+v[0]+'</li>';
                                        });
                                        html += '<\div><ul>';
                                        info.append(html);
                                        info.slideDown();
                                    }
                                });
                            }
                        },
                        somethingElse2: {
                            text: 'خیر',
                            btnClass: 'btn-red',
                            action: function () {
                                swal({
                                    title: "تایید نشد",
                                    text: "",
                                    type: "warning",
                                    timer: 1500
                                });
                            }
                        }
                    }
                });
            }
        });
    </script>

    @if (alert()->ready())
        <script>
            swal({
                title: "{!! alert()->message() !!}",
                text: "{!! alert()->option('text') !!}",
                type: "{!! alert()->type() !!}",
                @if(alert()->option('timer'))
                timer: "{!! alert()->option('timer') !!}",
                showConfirmButton: false,
                @else
                showConfirmButton: true,
                confirmButtonText :'باشه',
                @endif
            });
        </script>
    @endif
@endsection