@extends('/CRM/layout')
@section('content')
    <div class="page-header head-section">
        <div class="btn-group" style=" margin-right: 5px">
            <a href="{{route('category.show')}}" class="btn btn-sm btn-primary"><i class="fa fa-arrow-right"></i> بازگشت </a>
        </div>
        <h3 style="text-align: center">
            <i class="fa fa-tag" ></i>
            ویرایش <span class="title bold" style="color:#ff4f4f">{{$category->category}} </span>
        </h3>
    </div>
    <div id="alerts">
        @include('errors.formAlert')
    </div>
    <div class="panel panel-default">
        <div class="panel-heading">
            <h3 class="panel-title FarsiFont"><i class="fa fa-list"></i>&nbsp;ویرایش دسته بندی</h3>
        </div>
        <div class="panel-body">
            <div class="col-sm-8">
                <form class="form-horizontal" id="uploadForm" action="{{route('category.update',$category->id)}}" role="form" method="POST" >
                    {{csrf_field()}}
                    <div class="form-group">
                        <label class="col-sm-3 control-label">عنوان دسته بندی</label>
                        <div class="col-sm-9">
                            <input type="text" class="form-control" id="category" name="category" placeholder="عنوان دسته بندی" value="{{$category->category or old('category')}}">
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-sm-3 control-label">نوع کالای مربوطه</label>
                        <div class="col-sm-9">
                            <select class="form-control" id="stuffType" name="stuffType" data-placeholder="انتخاب کنید...">
                                <option>انتخاب کنید...</option>
                                @foreach($stuffTypes as $stuffType)
                                    <option value="{{$stuffType->id}}"
                                            @if(!is_null(old('$stuffType')) && old('$stuffType') == $stuffType->id)
                                            selected
                                            @elseif($category->stuffType_id == $stuffType->id)
                                            selected
                                            @endif
                                    >{{$loop->iteration}} - {{$stuffType->stuffType}}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-sm-3 control-label">نوع دسته بندی</label>
                        <div class="col-sm-9">
                            <input type="radio" name="type" id="status0" value="0" style="margin-right: 30px;" @if($category->type == 0) checked @endif >&nbsp;بر اساس رنگ
                            <input type="radio" name="type" id="status1" value="1" style="margin-right: 50px;" @if($category->type == 1) checked @endif > بر اساس سایز
                            <input type="radio" name="type" id="status2" value="2" style="margin-right: 50px;" @if($category->type == 2) checked @endif > هر دو
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-green">ثبت</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection

