@extends('/CRM/layout')

@section('head')
    <link href="/ui/jquery-ui.min.css" rel="stylesheet" type="text/css">
    <script src="/ui/jquery-ui.min.js"></script>

    <style>
        .col-sm-1 button{
            margin-top: 1.7em;
        }
        @media screen and (max-width: 755px){
            .col-sm-1 button{
                margin-top: 0em;
            }
        }
    </style>

@stop

@section('content')

    @if(session()->has('message') && session()->has('messageType'))
        <br>
        @if(session('messageType') == 'success')
            <div class="alert alert-success">
                <p>{{session('message')}}</p>
            </div>
        @elseif(session('messageType') == 'failure')
            <div class="alert alert-danger">
                <p>{{session('message')}}</p>
            </div>
        @endif
    @endif

    @if(count($errors) > 0)
        @php
            $hasError = true;
        @endphp
        <div class="alert alert-danger">
            <ul>
                @foreach($errors->all() as $error)
                    <li>{{$error}}</li>
                @endforeach
            </ul>
        </div>
    @else
        @php
            $hasError = false;
        @endphp
    @endif

    <div class="row">
        <a href="/CRM/createBrand" class="btn btn-primary"><span class="glyphicon glyphicon-arrow-left"></span> <strong>بازگشت</strong> </a>
        <a href="/CRM/brand/delete/{{$brandId}}" class="btn btn-danger">حذف کل سفارش</a>
    </div>
    <h1>برند: {{$brandName}}</h1>
    <form  method="post" action="/CRM/brand/edit">

        <div class="row">
            <p class="form-group col-sm-5">
                <label for="brand">برای ویرایش، فیلد زیر را اصلاح کنید</label>
                <input type="text" class="form-control" id="brand" name="brandName" placeholder="نام دسته بندی"
                       @if(!$hasError && !is_null($brandName))
                       value="{{$brandName}}"
                       @else
                       value="{{old("brandName")}}"
                        @endif >
            </p>

            <p class="col-sm-1">
            </p>
            <hr class="visible-xs-block">
        </div>
        <input type="hidden" name="brandId" value="{{$brandId}}">
        <input type='submit' class='btn btn-success' name='send' id='sendBtn' value='ثبت اطلاعات'>
        {{csrf_field()}}
    </form>
@stop

@section('footer')


@stop