@extends('/CRM/layout')

@section('head')

@stop

@section('content')
    @if(session()->has('message') && session()->has('messageType'))
        <br>
        @if(session('messageType') == 'success')
            <div class="alert alert-success">
                <p>{{session('message')}}</p>
            </div>
        @elseif(session('messageType') == 'failure')
            <div class="alert alert-danger">
                <p>{{session('message')}}</p>
            </div>
        @endif
    @endif
    <a href="/CRM/store/setting" class="btn btn-green"><span class="glyphicon glyphicon-arrow-left"></span> <strong>بازگشت</strong> </a>
    <h2>تعریف برند جدید <button class="btn btn-primary" onclick="addNewItem(id)"><span class="glyphicon glyphicon-plus"></span></button></h2>
    <form id="addItem" class="form-horizontal" action="/addNewBrand" method="post">
        {{csrf_field()}}
    </form>

    @if( isset($items) && count($items)>0)
        <div class="m-heading-1 border-green m-bordered">
            <h4>برندهای تعریف شده:</h4>
        </div>
        @php
            $count = count($items);
        @endphp
        <table class="table table-striped table-bordered">
            @for( $i=0 ; $i<$count ; $i++)
                <tr>
                    <td class="text-center">
                        {{$i+1}}
                    </td>
                    <td class="text-center">
                        {{$items[$i]->brandName}}
                    </td>
                    <td class="text-left">
                        <div class="btn-group">
                            <a href="brand/edit/{{$items[$i]->id}}" class="btn btn-success">ویرایش</a>
                            <a href="brand/delete/{{$items[$i]->id}}" class="btn btn-danger">حذف</a>
                        </div>
                    </td>
                    @if( ($i+1) < $count)
                        <td class="text-center">
                            {{$i+2}}
                        </td>
                        <td class="text-center">
                            {{$items[++$i]->brandName}}
                        </td>
                        <td class="text-left">
                            <div class="btn-group">
                                <a href="brand/edit/{{$items[$i]->id}}" class="btn btn-success">ویرایش</a>
                                <a href="brand/delete/{{$items[$i]->id}}" class="btn btn-danger">حذف</a>
                            </div>
                        </td>
                    @else
                        <td></td>
                    @endif
                </tr>
            @endfor
        </table>
    @else
        <div class="m-heading-1 border-green m-bordered">
            <h4>هیچ برندی تعریف نشده</h4>
        </div>
    @endif


@stop

@section('footer')
    <script>
        var id = 1;
        function addNewItem(){

            if( id === 1){
                var btn = $("<div class='form-group'></div>");
                btn.html("<div class='col-xs-offset-1'><input type='submit' class='btn btn-success' name='send' id='sendBtn' value='ثبت اطلاعات'></div>");
                $("#addItem").append(btn);
            }

            var inputGroup = $("<div class='form-group'></div>");
            inputGroup.html("<label class='control-label col-xs-1' for='" + id + "'>" + id + "</label><div class='col-xs-8'><input type='text' class='form-control' name='" + id +"' id='" + id + "'></div>");
            $("#sendBtn").before(inputGroup);
            id++;
        }
    </script>
@stop