@extends('/CRM/layout')
<!-- BEGIN PAGE BAR -->
@section('pageBar')
    <li>
        <a href="Dashboard">خانه</a>
        <i class="fa fa-circle"></i>
    </li>
    <li>
        <span>پنل مدیریت</span>
        <i class="fa fa-circle"></i>
    </li>
    <li>
        <span>پروفایل</span>
    </li>

@stop
@section('content')
    @if(session()->has('message') && session()->has('messageType'))
        <br>
        @if(session('messageType') == 'success')
            <div class="alert alert-success">
                <p>{{session('message')}}</p>
            </div>
        @elseif(session('messageType') == 'failure')
            <div class="alert alert-danger">
                <p>{{session('message')}}</p>
            </div>
        @endif
    @endif
    @if(count($errors) > 0)
        @php
            $hasError = true;
        @endphp
        <div class="alert alert-danger">
            <ul>
                @foreach($errors->all() as $error)
                    <li>{{$error}}</li>
                @endforeach
            </ul>
        </div>
    @else
        @php
            $hasError = false;
        @endphp
    @endif
            <!-- BEGIN PAGE TITLE-->
            <h1 class="page-title">  <small>پروفایل کاربری</small>
                {{$user->userName}}
            </h1>
            <!-- END PAGE TITLE-->
            <!-- END PAGE HEADER-->
            <div class="profile">
                <div class="tabbable-line tabbable-full-width">
                    <ul class="nav nav-tabs">
                        <li class="active">
                            <a href="#tab_1_1" data-toggle="tab"> حساب کاربری </a>
                        </li>
                        {{--<li>--}}
                            {{--<a href="#tab_1_3" data-toggle="tab"> راهنما </a>--}}
                        {{--</li>--}}
                    </ul>
                    <div class="tab-content">
                        <!--tab_1_2-->
                        <div class="tab-pane active" id="tab_1_1">
                            <div class="row profile-account">
                                <div class="col-md-3">
                                    <ul class="ver-inline-menu tabbable margin-bottom-10">
                                        <li class="active">
                                            <a data-toggle="tab" href="#tab_1-1">
                                                <i class="fa fa-cog"></i> اطلاعات شخصی </a>
                                            <span class="after"> </span>
                                        </li>
                                        <li>
                                            <a data-toggle="tab" href="#tab_3-3">
                                                <i class="fa fa-lock"></i> تغییر رمز عبور </a>
                                        </li>
                                        {{--<li>--}}
                                            {{--<a data-toggle="tab" href="#tab_4-4">--}}
                                                {{--<i class="fa fa-eye"></i> حریم شخصی </a>--}}
                                        {{--</li>--}}
                                    </ul>
                                </div>
                                <div class="col-md-9">
                                    <div class="tab-content">
                                        <div id="tab_1-1" class="tab-pane active">
                                            <form role="form" method="post" action="{{route('profile_save')}}">
                                                {{csrf_field()}}
                                                <div class="form-group">
                                                    <input type="text" name="userId" value="{{$user->id}}" style="display: none" />
                                                <label class="control-label">نام کاربر</label>
                                                    <input type="text" name="userName" value="{{$user->fname}} {{$user->lname}}" class="form-control" /> </div>
                                                <div class="form-group">
                                                    <label class="control-label">ایمیل</label>
                                                    <input type="text" name="email" value="{{$user->email}}" class="form-control"/> </div>
                                                <div class="form-group">
                                                    <label class="control-label">شماره موبایل</label>
                                                    <input type="text" placeholder="{{$user->mobile}}" class="form-control" readonly/> </div>
                                                <div class="form-group">
                                                    <label class="control-label">تاریخ ثبت کاربر</label>
                                                    <input type="text" placeholder="{{$user->created_at}}" class="form-control" readonly/> </div>
                                                <div class="margiv-top-10">
                                                    <button type="submit" class="btn green"> ذخیره تغییرات </button>
                                                </div>
                                            </form>
                                        </div>
                                        <div id="tab_3-3" class="tab-pane">
                                            <form role="form" method="post" action="{{route('profile_passwordReset')}}">
                                                {{csrf_field()}}
                                                <div class="form-group">
                                                    <input type="text" name="userId" value="{{$user->id}}" style="display: none" />
                                                    <label class="control-label">رمز عبور قبلی</label>
                                                    <input type="password" name="old_password" class="form-control" /> </div>
                                                <div class="form-group">
                                                    <label class="control-label">رمز عبور جدید</label>
                                                    <input type="password" name="password" class="form-control" /> </div>
                                                <div class="form-group">
                                                    <label class="control-label">تکرار رمز عبور جدید</label>
                                                    <input type="password" name="password_confirmation" class="form-control" />
                                                </div>
                                                <div class="margin-top-10">
                                                    <button type="submit" class="btn green"> تغییر رمز </button>
                                                </div>
                                            </form>
                                        </div>
                                        {{--<div id="tab_4-4" class="tab-pane">--}}
                                            {{--<form action="#">--}}
                                                {{--<table class="table table-bordered table-striped">--}}
                                                    {{--<tr>--}}
                                                        {{--<td> Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus.. </td>--}}
                                                        {{--<td>--}}
                                                            {{--<div class="mt-radio-inline">--}}
                                                                {{--<label class="mt-radio">--}}
                                                                    {{--<input type="radio" name="optionsRadios1" value="option1" /> Yes--}}
                                                                    {{--<span></span>--}}
                                                                {{--</label>--}}
                                                                {{--<label class="mt-radio">--}}
                                                                    {{--<input type="radio" name="optionsRadios1" value="option2" checked/> No--}}
                                                                    {{--<span></span>--}}
                                                                {{--</label>--}}
                                                            {{--</div>--}}
                                                        {{--</td>--}}
                                                    {{--</tr>--}}
                                                    {{--<tr>--}}
                                                        {{--<td> Enim eiusmod high life accusamus terry richardson ad squid wolf moon </td>--}}
                                                        {{--<td>--}}
                                                            {{--<div class="mt-radio-inline">--}}
                                                                {{--<label class="mt-radio">--}}
                                                                    {{--<input type="radio" name="optionsRadios21" value="option1" /> Yes--}}
                                                                    {{--<span></span>--}}
                                                                {{--</label>--}}
                                                                {{--<label class="mt-radio">--}}
                                                                    {{--<input type="radio" name="optionsRadios21" value="option2" checked/> No--}}
                                                                    {{--<span></span>--}}
                                                                {{--</label>--}}
                                                            {{--</div>--}}
                                                        {{--</td>--}}
                                                    {{--</tr>--}}
                                                    {{--<tr>--}}
                                                        {{--<td> Enim eiusmod high life accusamus terry richardson ad squid wolf moon </td>--}}
                                                        {{--<td>--}}
                                                            {{--<div class="mt-radio-inline">--}}
                                                                {{--<label class="mt-radio">--}}
                                                                    {{--<input type="radio" name="optionsRadios31" value="option1" /> Yes--}}
                                                                    {{--<span></span>--}}
                                                                {{--</label>--}}
                                                                {{--<label class="mt-radio">--}}
                                                                    {{--<input type="radio" name="optionsRadios31" value="option2" checked/> No--}}
                                                                    {{--<span></span>--}}
                                                                {{--</label>--}}
                                                            {{--</div>--}}
                                                        {{--</td>--}}
                                                    {{--</tr>--}}
                                                    {{--<tr>--}}
                                                        {{--<td> Enim eiusmod high life accusamus terry richardson ad squid wolf moon </td>--}}
                                                        {{--<td>--}}
                                                            {{--<div class="mt-radio-inline">--}}
                                                                {{--<label class="mt-radio">--}}
                                                                    {{--<input type="radio" name="optionsRadios41" value="option1" /> Yes--}}
                                                                    {{--<span></span>--}}
                                                                {{--</label>--}}
                                                                {{--<label class="mt-radio">--}}
                                                                    {{--<input type="radio" name="optionsRadios41" value="option2" checked/> No--}}
                                                                    {{--<span></span>--}}
                                                                {{--</label>--}}
                                                            {{--</div>--}}
                                                        {{--</td>--}}
                                                    {{--</tr>--}}
                                                {{--</table>--}}
                                                {{--<!--end profile-settings-->--}}
                                                {{--<div class="margin-top-10">--}}
                                                    {{--<a href="javascript:;" class="btn green"> Save Changes </a>--}}
                                                    {{--<a href="javascript:;" class="btn default"> Cancel </a>--}}
                                                {{--</div>--}}
                                            {{--</form>--}}
                                        {{--</div>--}}
                                    </div>
                                </div>
                                <!--end col-md-9-->
                            </div>
                        </div>
                        <!--end tab-pane-->
                        {{--<div class="tab-pane" id="tab_1_3">--}}
                            {{--<div class="row">--}}
                                {{--<div class="col-md-2">--}}
                                    {{--<ul class="ver-inline-menu tabbable margin-bottom-10">--}}
                                        {{--<li class="active">--}}
                                            {{--<a data-toggle="tab" href="#tab_1">--}}
                                                {{--<i class="fa fa-briefcase"></i> General Questions </a>--}}
                                            {{--<span class="after"> </span>--}}
                                        {{--</li>--}}
                                        {{--<li>--}}
                                            {{--<a data-toggle="tab" href="#tab_2">--}}
                                                {{--<i class="fa fa-group"></i> Membership </a>--}}
                                        {{--</li>--}}
                                        {{--<li>--}}
                                            {{--<a data-toggle="tab" href="#tab_3">--}}
                                                {{--<i class="fa fa-leaf"></i> Terms Of Service </a>--}}
                                        {{--</li>--}}
                                        {{--<li>--}}
                                            {{--<a data-toggle="tab" href="#tab_1">--}}
                                                {{--<i class="fa fa-info-circle"></i> License Terms </a>--}}
                                        {{--</li>--}}
                                        {{--<li>--}}
                                            {{--<a data-toggle="tab" href="#tab_2">--}}
                                                {{--<i class="fa fa-tint"></i> Payment Rules </a>--}}
                                        {{--</li>--}}
                                        {{--<li>--}}
                                            {{--<a data-toggle="tab" href="#tab_3">--}}
                                                {{--<i class="fa fa-plus"></i> Other Questions </a>--}}
                                        {{--</li>--}}
                                    {{--</ul>--}}
                                {{--</div>--}}
                                {{--<div class="col-md-10">--}}
                                    {{--<div class="tab-content">--}}
                                        {{--<div id="tab_1" class="tab-pane active">--}}
                                            {{--<div id="accordion1" class="panel-group">--}}
                                                {{--<div class="panel panel-default">--}}
                                                    {{--<div class="panel-heading">--}}
                                                        {{--<h4 class="panel-title">--}}
                                                            {{--<a class="accordion-toggle" data-toggle="collapse" data-parent="#accordion1" href="#accordion1_1"> 1. Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry ? </a>--}}
                                                        {{--</h4>--}}
                                                    {{--</div>--}}
                                                    {{--<div id="accordion1_1" class="panel-collapse collapse in">--}}
                                                        {{--<div class="panel-body"> Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt--}}
                                                            {{--laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et. Nihil anim keffiyeh helvetica, craft beer labore--}}
                                                            {{--wes anderson cred nesciunt sapiente ea proident. Ad vegan excepteur butcher vice lomo. Leggings occaecat craft beer farm-to-table, raw denim aesthetic synth nesciunt you probably--}}
                                                            {{--haven't heard of them accusamus labore sustainable VHS. </div>--}}
                                                    {{--</div>--}}
                                                {{--</div>--}}
                                                {{--<div class="panel panel-default">--}}
                                                    {{--<div class="panel-heading">--}}
                                                        {{--<h4 class="panel-title">--}}
                                                            {{--<a class="accordion-toggle" data-toggle="collapse" data-parent="#accordion1" href="#accordion1_2"> 2. Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry ? </a>--}}
                                                        {{--</h4>--}}
                                                    {{--</div>--}}
                                                    {{--<div id="accordion1_2" class="panel-collapse collapse">--}}
                                                        {{--<div class="panel-body"> Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et. Anim pariatur cliche reprehenderit,--}}
                                                            {{--enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf--}}
                                                            {{--moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et. Nihil anim keffiyeh helvetica, craft beer labore wes anderson cred nesciunt sapiente--}}
                                                            {{--ea proident. Ad vegan excepteur butcher vice lomo. Leggings occaecat craft beer farm-to-table, raw denim aesthetic synth nesciunt you probably haven't heard of them accusamus labore--}}
                                                            {{--sustainable VHS. </div>--}}
                                                    {{--</div>--}}
                                                {{--</div>--}}
                                                {{--<div class="panel panel-success">--}}
                                                    {{--<div class="panel-heading">--}}
                                                        {{--<h4 class="panel-title">--}}
                                                            {{--<a class="accordion-toggle" data-toggle="collapse" data-parent="#accordion1" href="#accordion1_3"> 3. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor ? </a>--}}
                                                        {{--</h4>--}}
                                                    {{--</div>--}}
                                                    {{--<div id="accordion1_3" class="panel-collapse collapse">--}}
                                                        {{--<div class="panel-body"> Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et. Anim pariatur cliche reprehenderit,--}}
                                                            {{--enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf--}}
                                                            {{--moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et. Nihil anim keffiyeh helvetica, craft beer labore wes anderson cred nesciunt sapiente--}}
                                                            {{--ea proident. Ad vegan excepteur butcher vice lomo. Leggings occaecat craft beer farm-to-table, raw denim aesthetic synth nesciunt you probably haven't heard of them accusamus labore--}}
                                                            {{--sustainable VHS. </div>--}}
                                                    {{--</div>--}}
                                                {{--</div>--}}
                                                {{--<div class="panel panel-warning">--}}
                                                    {{--<div class="panel-heading">--}}
                                                        {{--<h4 class="panel-title">--}}
                                                            {{--<a class="accordion-toggle" data-toggle="collapse" data-parent="#accordion1" href="#accordion1_4"> 4. Wolf moon officia aute, non cupidatat skateboard dolor brunch ? </a>--}}
                                                        {{--</h4>--}}
                                                    {{--</div>--}}
                                                    {{--<div id="accordion1_4" class="panel-collapse collapse">--}}
                                                        {{--<div class="panel-body"> 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin--}}
                                                            {{--coffee nulla assumenda shoreditch et. Nihil anim keffiyeh helvetica, craft beer labore wes anderson cred nesciunt sapiente ea proident. Ad vegan excepteur butcher vice lomo. Leggings--}}
                                                            {{--occaecat craft beer farm-to-table, raw denim aesthetic synth nesciunt you probably haven't heard of them accusamus labore sustainable VHS. </div>--}}
                                                    {{--</div>--}}
                                                {{--</div>--}}
                                                {{--<div class="panel panel-danger">--}}
                                                    {{--<div class="panel-heading">--}}
                                                        {{--<h4 class="panel-title">--}}
                                                            {{--<a class="accordion-toggle" data-toggle="collapse" data-parent="#accordion1" href="#accordion1_5"> 5. Leggings occaecat craft beer farm-to-table, raw denim aesthetic ? </a>--}}
                                                        {{--</h4>--}}
                                                    {{--</div>--}}
                                                    {{--<div id="accordion1_5" class="panel-collapse collapse">--}}
                                                        {{--<div class="panel-body"> 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin--}}
                                                            {{--coffee nulla assumenda shoreditch et. Nihil anim keffiyeh helvetica, craft beer labore wes anderson cred nesciunt sapiente ea proident. Ad vegan excepteur butcher vice lomo. Leggings--}}
                                                            {{--occaecat craft beer farm-to-table, raw denim aesthetic synth nesciunt you probably haven't heard of them accusamus labore sustainable VHS. Food truck quinoa nesciunt laborum eiusmod.--}}
                                                            {{--Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et </div>--}}
                                                    {{--</div>--}}
                                                {{--</div>--}}
                                                {{--<div class="panel panel-default">--}}
                                                    {{--<div class="panel-heading">--}}
                                                        {{--<h4 class="panel-title">--}}
                                                            {{--<a class="accordion-toggle" data-toggle="collapse" data-parent="#accordion1" href="#accordion1_6"> 6. Leggings occaecat craft beer farm-to-table, raw denim aesthetic synth ? </a>--}}
                                                        {{--</h4>--}}
                                                    {{--</div>--}}
                                                    {{--<div id="accordion1_6" class="panel-collapse collapse">--}}
                                                        {{--<div class="panel-body"> 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin--}}
                                                            {{--coffee nulla assumenda shoreditch et. Nihil anim keffiyeh helvetica, craft beer labore wes anderson cred nesciunt sapiente ea proident. Ad vegan excepteur butcher vice lomo. Leggings--}}
                                                            {{--occaecat craft beer farm-to-table, raw denim aesthetic synth nesciunt you probably haven't heard of them accusamus labore sustainable VHS. Food truck quinoa nesciunt laborum eiusmod.--}}
                                                            {{--Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et </div>--}}
                                                    {{--</div>--}}
                                                {{--</div>--}}
                                                {{--<div class="panel panel-default">--}}
                                                    {{--<div class="panel-heading">--}}
                                                        {{--<h4 class="panel-title">--}}
                                                            {{--<a class="accordion-toggle" data-toggle="collapse" data-parent="#accordion1" href="#accordion1_7"> 7. Ad vegan excepteur butcher vice lomo. Leggings occaecat craft ? </a>--}}
                                                        {{--</h4>--}}
                                                    {{--</div>--}}
                                                    {{--<div id="accordion1_7" class="panel-collapse collapse">--}}
                                                        {{--<div class="panel-body"> 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin--}}
                                                            {{--coffee nulla assumenda shoreditch et. Nihil anim keffiyeh helvetica, craft beer labore wes anderson cred nesciunt sapiente ea proident. Ad vegan excepteur butcher vice lomo. Leggings--}}
                                                            {{--occaecat craft beer farm-to-table, raw denim aesthetic synth nesciunt you probably haven't heard of them accusamus labore sustainable VHS. Food truck quinoa nesciunt laborum eiusmod.--}}
                                                            {{--Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et </div>--}}
                                                    {{--</div>--}}
                                                {{--</div>--}}
                                            {{--</div>--}}
                                        {{--</div>--}}
                                        {{--<div id="tab_2" class="tab-pane">--}}
                                            {{--<div id="accordion2" class="panel-group">--}}
                                                {{--<div class="panel panel-warning">--}}
                                                    {{--<div class="panel-heading">--}}
                                                        {{--<h4 class="panel-title">--}}
                                                            {{--<a class="accordion-toggle" data-toggle="collapse" data-parent="#accordion2" href="#accordion2_1"> 1. Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry ? </a>--}}
                                                        {{--</h4>--}}
                                                    {{--</div>--}}
                                                    {{--<div id="accordion2_1" class="panel-collapse collapse in">--}}
                                                        {{--<div class="panel-body">--}}
                                                            {{--<p> Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa--}}
                                                                {{--nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et. Nihil anim keffiyeh helvetica, craft--}}
                                                                {{--beer labore wes anderson cred nesciunt sapiente ea proident. Ad vegan excepteur butcher vice lomo. Leggings occaecat craft beer farm-to-table, raw denim aesthetic synth nesciunt--}}
                                                                {{--you probably haven't heard of them accusamus labore sustainable VHS. </p>--}}
                                                            {{--<p> Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa--}}
                                                                {{--nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et. Nihil anim keffiyeh helvetica, craft--}}
                                                                {{--beer labore wes anderson cred nesciunt sapiente ea proident. Ad vegan excepteur butcher vice lomo. Leggings occaecat craft beer farm-to-table, raw denim aesthetic synth nesciunt--}}
                                                                {{--you probably haven't heard of them accusamus labore sustainable VHS. </p>--}}
                                                        {{--</div>--}}
                                                    {{--</div>--}}
                                                {{--</div>--}}
                                                {{--<div class="panel panel-danger">--}}
                                                    {{--<div class="panel-heading">--}}
                                                        {{--<h4 class="panel-title">--}}
                                                            {{--<a class="accordion-toggle" data-toggle="collapse" data-parent="#accordion2" href="#accordion2_2"> 2. Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry ? </a>--}}
                                                        {{--</h4>--}}
                                                    {{--</div>--}}
                                                    {{--<div id="accordion2_2" class="panel-collapse collapse">--}}
                                                        {{--<div class="panel-body"> Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et. Anim pariatur cliche reprehenderit,--}}
                                                            {{--enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf--}}
                                                            {{--moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et. Nihil anim keffiyeh helvetica, craft beer labore wes anderson cred nesciunt sapiente--}}
                                                            {{--ea proident. Ad vegan excepteur butcher vice lomo. Leggings occaecat craft beer farm-to-table, raw denim aesthetic synth nesciunt you probably haven't heard of them accusamus labore--}}
                                                            {{--sustainable VHS. </div>--}}
                                                    {{--</div>--}}
                                                {{--</div>--}}
                                                {{--<div class="panel panel-success">--}}
                                                    {{--<div class="panel-heading">--}}
                                                        {{--<h4 class="panel-title">--}}
                                                            {{--<a class="accordion-toggle" data-toggle="collapse" data-parent="#accordion2" href="#accordion2_3"> 3. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor ? </a>--}}
                                                        {{--</h4>--}}
                                                    {{--</div>--}}
                                                    {{--<div id="accordion2_3" class="panel-collapse collapse">--}}
                                                        {{--<div class="panel-body"> Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et. Anim pariatur cliche reprehenderit,--}}
                                                            {{--enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf--}}
                                                            {{--moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et. Nihil anim keffiyeh helvetica, craft beer labore wes anderson cred nesciunt sapiente--}}
                                                            {{--ea proident. Ad vegan excepteur butcher vice lomo. Leggings occaecat craft beer farm-to-table, raw denim aesthetic synth nesciunt you probably haven't heard of them accusamus labore--}}
                                                            {{--sustainable VHS. </div>--}}
                                                    {{--</div>--}}
                                                {{--</div>--}}
                                                {{--<div class="panel panel-default">--}}
                                                    {{--<div class="panel-heading">--}}
                                                        {{--<h4 class="panel-title">--}}
                                                            {{--<a class="accordion-toggle" data-toggle="collapse" data-parent="#accordion2" href="#accordion2_4"> 4. Wolf moon officia aute, non cupidatat skateboard dolor brunch ? </a>--}}
                                                        {{--</h4>--}}
                                                    {{--</div>--}}
                                                    {{--<div id="accordion2_4" class="panel-collapse collapse">--}}
                                                        {{--<div class="panel-body"> 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin--}}
                                                            {{--coffee nulla assumenda shoreditch et. Nihil anim keffiyeh helvetica, craft beer labore wes anderson cred nesciunt sapiente ea proident. Ad vegan excepteur butcher vice lomo. Leggings--}}
                                                            {{--occaecat craft beer farm-to-table, raw denim aesthetic synth nesciunt you probably haven't heard of them accusamus labore sustainable VHS. </div>--}}
                                                    {{--</div>--}}
                                                {{--</div>--}}
                                                {{--<div class="panel panel-default">--}}
                                                    {{--<div class="panel-heading">--}}
                                                        {{--<h4 class="panel-title">--}}
                                                            {{--<a class="accordion-toggle" data-toggle="collapse" data-parent="#accordion2" href="#accordion2_5"> 5. Leggings occaecat craft beer farm-to-table, raw denim aesthetic ? </a>--}}
                                                        {{--</h4>--}}
                                                    {{--</div>--}}
                                                    {{--<div id="accordion2_5" class="panel-collapse collapse">--}}
                                                        {{--<div class="panel-body"> 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin--}}
                                                            {{--coffee nulla assumenda shoreditch et. Nihil anim keffiyeh helvetica, craft beer labore wes anderson cred nesciunt sapiente ea proident. Ad vegan excepteur butcher vice lomo. Leggings--}}
                                                            {{--occaecat craft beer farm-to-table, raw denim aesthetic synth nesciunt you probably haven't heard of them accusamus labore sustainable VHS. Food truck quinoa nesciunt laborum eiusmod.--}}
                                                            {{--Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et </div>--}}
                                                    {{--</div>--}}
                                                {{--</div>--}}
                                                {{--<div class="panel panel-default">--}}
                                                    {{--<div class="panel-heading">--}}
                                                        {{--<h4 class="panel-title">--}}
                                                            {{--<a class="accordion-toggle" data-toggle="collapse" data-parent="#accordion2" href="#accordion2_6"> 6. Leggings occaecat craft beer farm-to-table, raw denim aesthetic synth ? </a>--}}
                                                        {{--</h4>--}}
                                                    {{--</div>--}}
                                                    {{--<div id="accordion2_6" class="panel-collapse collapse">--}}
                                                        {{--<div class="panel-body"> 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin--}}
                                                            {{--coffee nulla assumenda shoreditch et. Nihil anim keffiyeh helvetica, craft beer labore wes anderson cred nesciunt sapiente ea proident. Ad vegan excepteur butcher vice lomo. Leggings--}}
                                                            {{--occaecat craft beer farm-to-table, raw denim aesthetic synth nesciunt you probably haven't heard of them accusamus labore sustainable VHS. Food truck quinoa nesciunt laborum eiusmod.--}}
                                                            {{--Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et </div>--}}
                                                    {{--</div>--}}
                                                {{--</div>--}}
                                                {{--<div class="panel panel-default">--}}
                                                    {{--<div class="panel-heading">--}}
                                                        {{--<h4 class="panel-title">--}}
                                                            {{--<a class="accordion-toggle" data-toggle="collapse" data-parent="#accordion2" href="#accordion2_7"> 7. Ad vegan excepteur butcher vice lomo. Leggings occaecat craft ? </a>--}}
                                                        {{--</h4>--}}
                                                    {{--</div>--}}
                                                    {{--<div id="accordion2_7" class="panel-collapse collapse">--}}
                                                        {{--<div class="panel-body"> 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin--}}
                                                            {{--coffee nulla assumenda shoreditch et. Nihil anim keffiyeh helvetica, craft beer labore wes anderson cred nesciunt sapiente ea proident. Ad vegan excepteur butcher vice lomo. Leggings--}}
                                                            {{--occaecat craft beer farm-to-table, raw denim aesthetic synth nesciunt you probably haven't heard of them accusamus labore sustainable VHS. Food truck quinoa nesciunt laborum eiusmod.--}}
                                                            {{--Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et </div>--}}
                                                    {{--</div>--}}
                                                {{--</div>--}}
                                            {{--</div>--}}
                                        {{--</div>--}}
                                        {{--<div id="tab_3" class="tab-pane">--}}
                                            {{--<div id="accordion3" class="panel-group">--}}
                                                {{--<div class="panel panel-danger">--}}
                                                    {{--<div class="panel-heading">--}}
                                                        {{--<h4 class="panel-title">--}}
                                                            {{--<a class="accordion-toggle" data-toggle="collapse" data-parent="#accordion3" href="#accordion3_1"> 1. Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry ? </a>--}}
                                                        {{--</h4>--}}
                                                    {{--</div>--}}
                                                    {{--<div id="accordion3_1" class="panel-collapse collapse in">--}}
                                                        {{--<div class="panel-body">--}}
                                                            {{--<p> Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa--}}
                                                                {{--nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et. </p>--}}
                                                            {{--<p> Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa--}}
                                                                {{--nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et. </p>--}}
                                                            {{--<p> Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et. Nihil anim keffiyeh helvetica,--}}
                                                                {{--craft beer labore wes anderson cred nesciunt sapiente ea proident. Ad vegan excepteur butcher vice lomo. Leggings occaecat craft beer farm-to-table, raw denim aesthetic synth--}}
                                                                {{--nesciunt you probably haven't heard of them accusamus labore sustainable VHS. </p>--}}
                                                        {{--</div>--}}
                                                    {{--</div>--}}
                                                {{--</div>--}}
                                                {{--<div class="panel panel-success">--}}
                                                    {{--<div class="panel-heading">--}}
                                                        {{--<h4 class="panel-title">--}}
                                                            {{--<a class="accordion-toggle" data-toggle="collapse" data-parent="#accordion3" href="#accordion3_2"> 2. Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry ? </a>--}}
                                                        {{--</h4>--}}
                                                    {{--</div>--}}
                                                    {{--<div id="accordion3_2" class="panel-collapse collapse">--}}
                                                        {{--<div class="panel-body"> Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et. Anim pariatur cliche reprehenderit,--}}
                                                            {{--enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf--}}
                                                            {{--moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et. Nihil anim keffiyeh helvetica, craft beer labore wes anderson cred nesciunt sapiente--}}
                                                            {{--ea proident. Ad vegan excepteur butcher vice lomo. Leggings occaecat craft beer farm-to-table, raw denim aesthetic synth nesciunt you probably haven't heard of them accusamus labore--}}
                                                            {{--sustainable VHS. </div>--}}
                                                    {{--</div>--}}
                                                {{--</div>--}}
                                                {{--<div class="panel panel-default">--}}
                                                    {{--<div class="panel-heading">--}}
                                                        {{--<h4 class="panel-title">--}}
                                                            {{--<a class="accordion-toggle" data-toggle="collapse" data-parent="#accordion3" href="#accordion3_3"> 3. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor ? </a>--}}
                                                        {{--</h4>--}}
                                                    {{--</div>--}}
                                                    {{--<div id="accordion3_3" class="panel-collapse collapse">--}}
                                                        {{--<div class="panel-body"> Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et. Anim pariatur cliche reprehenderit,--}}
                                                            {{--enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf--}}
                                                            {{--moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et. Nihil anim keffiyeh helvetica, craft beer labore wes anderson cred nesciunt sapiente--}}
                                                            {{--ea proident. Ad vegan excepteur butcher vice lomo. Leggings occaecat craft beer farm-to-table, raw denim aesthetic synth nesciunt you probably haven't heard of them accusamus labore--}}
                                                            {{--sustainable VHS. </div>--}}
                                                    {{--</div>--}}
                                                {{--</div>--}}
                                                {{--<div class="panel panel-default">--}}
                                                    {{--<div class="panel-heading">--}}
                                                        {{--<h4 class="panel-title">--}}
                                                            {{--<a class="accordion-toggle" data-toggle="collapse" data-parent="#accordion3" href="#accordion3_4"> 4. Wolf moon officia aute, non cupidatat skateboard dolor brunch ? </a>--}}
                                                        {{--</h4>--}}
                                                    {{--</div>--}}
                                                    {{--<div id="accordion3_4" class="panel-collapse collapse">--}}
                                                        {{--<div class="panel-body"> 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin--}}
                                                            {{--coffee nulla assumenda shoreditch et. Nihil anim keffiyeh helvetica, craft beer labore wes anderson cred nesciunt sapiente ea proident. Ad vegan excepteur butcher vice lomo. Leggings--}}
                                                            {{--occaecat craft beer farm-to-table, raw denim aesthetic synth nesciunt you probably haven't heard of them accusamus labore sustainable VHS. </div>--}}
                                                    {{--</div>--}}
                                                {{--</div>--}}
                                                {{--<div class="panel panel-default">--}}
                                                    {{--<div class="panel-heading">--}}
                                                        {{--<h4 class="panel-title">--}}
                                                            {{--<a class="accordion-toggle" data-toggle="collapse" data-parent="#accordion3" href="#accordion3_5"> 5. Leggings occaecat craft beer farm-to-table, raw denim aesthetic ? </a>--}}
                                                        {{--</h4>--}}
                                                    {{--</div>--}}
                                                    {{--<div id="accordion3_5" class="panel-collapse collapse">--}}
                                                        {{--<div class="panel-body"> 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin--}}
                                                            {{--coffee nulla assumenda shoreditch et. Nihil anim keffiyeh helvetica, craft beer labore wes anderson cred nesciunt sapiente ea proident. Ad vegan excepteur butcher vice lomo. Leggings--}}
                                                            {{--occaecat craft beer farm-to-table, raw denim aesthetic synth nesciunt you probably haven't heard of them accusamus labore sustainable VHS. Food truck quinoa nesciunt laborum eiusmod.--}}
                                                            {{--Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et </div>--}}
                                                    {{--</div>--}}
                                                {{--</div>--}}
                                                {{--<div class="panel panel-default">--}}
                                                    {{--<div class="panel-heading">--}}
                                                        {{--<h4 class="panel-title">--}}
                                                            {{--<a class="accordion-toggle" data-toggle="collapse" data-parent="#accordion3" href="#accordion3_6"> 6. Leggings occaecat craft beer farm-to-table, raw denim aesthetic synth ? </a>--}}
                                                        {{--</h4>--}}
                                                    {{--</div>--}}
                                                    {{--<div id="accordion3_6" class="panel-collapse collapse">--}}
                                                        {{--<div class="panel-body"> 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin--}}
                                                            {{--coffee nulla assumenda shoreditch et. Nihil anim keffiyeh helvetica, craft beer labore wes anderson cred nesciunt sapiente ea proident. Ad vegan excepteur butcher vice lomo. Leggings--}}
                                                            {{--occaecat craft beer farm-to-table, raw denim aesthetic synth nesciunt you probably haven't heard of them accusamus labore sustainable VHS. Food truck quinoa nesciunt laborum eiusmod.--}}
                                                            {{--Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et </div>--}}
                                                    {{--</div>--}}
                                                {{--</div>--}}
                                                {{--<div class="panel panel-default">--}}
                                                    {{--<div class="panel-heading">--}}
                                                        {{--<h4 class="panel-title">--}}
                                                            {{--<a class="accordion-toggle" data-toggle="collapse" data-parent="#accordion3" href="#accordion3_7"> 7. Ad vegan excepteur butcher vice lomo. Leggings occaecat craft ? </a>--}}
                                                        {{--</h4>--}}
                                                    {{--</div>--}}
                                                    {{--<div id="accordion3_7" class="panel-collapse collapse">--}}
                                                        {{--<div class="panel-body"> 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin--}}
                                                            {{--coffee nulla assumenda shoreditch et. Nihil anim keffiyeh helvetica, craft beer labore wes anderson cred nesciunt sapiente ea proident. Ad vegan excepteur butcher vice lomo. Leggings--}}
                                                            {{--occaecat craft beer farm-to-table, raw denim aesthetic synth nesciunt you probably haven't heard of them accusamus labore sustainable VHS. Food truck quinoa nesciunt laborum eiusmod.--}}
                                                            {{--Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et </div>--}}
                                                    {{--</div>--}}
                                                {{--</div>--}}
                                            {{--</div>--}}
                                        {{--</div>--}}
                                    {{--</div>--}}
                                {{--</div>--}}
                            {{--</div>--}}
                        {{--</div>--}}
                        {{--<!--end tab-pane-->--}}
                    </div>
                </div>
            </div>

        <!-- END CONTENT BODY -->


@endsection