@extends('/CRM/layout')

@section('content')
    <div class="portlet light bordered main">
        <div class="page-header head-section">
            <div class="btn-group"  style="float: left">
                <a href="{{ route('roles.index') }}" class="btn btn-sm btn-info">سطوح دسترسی</a>
                <a href="{{ route('level.index') }}" class="btn btn-sm btn-success">کاربران مدیریت</a>
            </div>
            <h2>کاربران</h2>
        </div>
        <div class="table-responsive">
            <table class="table table-striped table-bordered">
                <thead>
                <tr>
                    <th>نام کاربر</th>
                    <th>مقام</th>
                    <th>زمان ثبت نام</th>
                    <th>تنظیمات</th>
                </tr>
                </thead>
                <tbody>
                @foreach($users as $user)
                    <tr>
                        <td>{{ $user->fname }}</td>

                        <td>{{ $user->role }}</td>

                        <td>{{ $user->created_at }}</td>
                        <td>
                            <form action="{{ route('users.destroy'  , ['id' => $user->id]) }}" method="post">
                                {{ method_field('delete') }}
                                {{ csrf_field() }}
                                <div class="btn-group btn-group-xs">
                                    <button type="submit" class="btn btn-danger">حذف</button>
                                </div>
                            </form>
                        </td>
                    </tr>
                @endforeach
                </tbody>
            </table>
        </div>
        <div style="text-align: center">
            {!! $users->render() !!}
        </div>
    </div>
@endsection