@extends('/CRM/layout')

@section('footer')
    <script>
        $(document).ready(function () {
            $('#user_id').selectpicker();
            $('#role_id').selectpicker();
        })
    </script>
@endsection


@section('content')
    <div class="portlet light bordered main">
        <div class="page-header head-section">
            <h2>ثبت مقام</h2>
        </div>
        <form class="form-horizontal" action="{{ route('level.store') }}" method="post" enctype="multipart/form-data">
            {{ csrf_field() }}
            @include('CRM.Admin.section.errors')
            <div class="form-group">
                <div class="col-sm-12">
                    <label for="user_id" class="control-label">کاربران</label>
                    <select class="form-control" name="user_id" id="user_id" data-live-search="true">
                        @foreach(\App\Models\User::where('role' , 'admin')->get() as $user)
                            <option value="{{ $user->id }}">{{ $user->fname }} {{ $user->lname }} ({{ $user->mobile }})</option>
                        @endforeach
                    </select>
                </div>
            </div>
            <div class="form-group">
                <div class="col-sm-12">
                    <label for="role_id" class="control-label">مقام ها</label>
                    <select class="form-control" name="role_id" id="role_id">
                        @foreach(\App\Models\Role::all() as $role)
                            <option value="{{ $role->id }}">{{ $role->name }} - {{ $role->description }}</option>
                        @endforeach
                    </select>
                </div>
            </div>
            <div class="form-group">
                <div class="col-sm-12">
                    <button type="submit" class="btn btn-danger">ارسال</button>
                </div>
            </div>
        </form>
    </div>
@endsection