@extends('/CRM/layout')

@section('content')
    <div class="portlet light bordered main">
        <div class="page-header head-section">
            <div class="btn-group"  style="float: left">
                <a href="{{ route('level.create') }}" class="btn btn-sm btn-info" >ثبت مقام برای کاربر</a>
            </div>
            <h2>کاربران پنل مدیریت</h2>
        </div>
        <div class="table-responsive">
            <table class="table table-striped table-bordered">
                <thead>
                <tr>
                    <th>نام کاربر</th>
                    <th>مقام</th>
                    <th>تنظیمات</th>
                </tr>
                </thead>
                <tbody>
                @foreach($roles as $role)
                    @if(count($role->users))
                        @foreach($role->users as $user)
                            <tr>
                                <td>{{ $user->fname }} {{ $user->lname }} ({{ $user->mobile }})</td>
                                <td>{{ $role->name }} - {{ $role->description }}</td>
                                <td>
                                    <form action="{{ route('level.destroy'  , ['id' => $user->id]) }}" method="post">
                                        {{ method_field('delete') }}
                                        {{ csrf_field() }}
                                        <div class="btn-group btn-group-xs">
                                            <a href="{{ route('level.edit' , ['id' => $user->id]) }}"  class="btn btn-primary">ویرایش</a>
                                            <button type="submit" class="btn btn-danger">حذف</button>
                                        </div>
                                    </form>
                                </td>
                            </tr>
                        @endforeach
                    @endif
                @endforeach
                </tbody>
            </table>
        </div>
        <div style="text-align: center">
            {!! $roles->render() !!}
        </div>
    </div>
@endsection