<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateFiltersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('filters', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('title_id')->unsigned();
            $table->string('name',255);
            $table->string('slug',255)->nullable();

            $table->integer('tec_id')->unsigned()->nullable();
            $table->foreign('tec_id' )->references('tec_id')->on('tec_info_products')->onDelete('cascade');

            $table->string('tec_code',50)->nullable();
            $table->string('url',255);
            $table->integer('priority');
            $table->smallInteger('status');
            $table->timestamps();
            $table->foreign('title_id' )->references('id')->on('filter_titles')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('filters');
    }
}
