<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateDynamicSubMenuSettings extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('dynamic_sub_menu_settings', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->increments('id');

            $table->integer('title_id')->unsigned();
            $table->foreign('title_id' )->references('id')->on('sub_menu_titles')->onDelete('cascade');

            $table->string('sub_title',250);
            $table->string('slug',250)->unique();

            $table->integer('priority');

            $table->smallInteger('title_type');

            $table->integer('category_id')->unsigned()->nullable();
            $table->foreign('category_id' )->references('id')->on('category')->onDelete('cascade');

            $table->integer('brand_id')->unsigned()->nullable();
            $table->foreign('brand_id' )->references('id')->on('brands')->onDelete('cascade');

            $table->integer('tec_id')->unsigned()->nullable();
            $table->foreign('tec_id' )->references('tec_id')->on('tec_info_products')->onDelete('cascade');

            $table->string('tec_code',50)->nullable();
            $table->string('url',255);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('dynamic_sub_menu_settings');

    }
}
