<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateTecInfoProductsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('tec_info_products', function (Blueprint $table) {
            $table->increments('tec_id');
            $table->unsignedInteger('tecInfo_id');
            $table->unsignedInteger('product_id');
            $table->text('value');
            $table->foreign('tecInfo_id' )->references('id')->on('products_tecinfo')->onDelete('cascade');
            $table->foreign('product_id' )->references('id')->on('products')->onDelete('cascade');
            $table->timestamps();
        });

    }


    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('tec_info_products');
    }
}
