<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateArticlesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('articles', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('category_id')->unsigned()->nullabel();
            $table->foreign( 'category_id' )->references('id')->on('article_categories')->onDelete('cascade');

            $table->string('title',100);
            $table->string('description',150);
            $table->longText('body');
            $table->string('image_path','100');
            $table->string('thumb_path','100');
            $table->string('tags','150');
            $table->string('slug','150');
            $table->integer('view_count')->default(0);
            $table->integer('user_id')->unsigned();
            $table->foreign('user_id')->references('id')->on('users');
            $table->boolean('status')->default(false);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('articles');
    }
}
