<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateAmazingsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('amazings', function (Blueprint $table) {
            $table->increments('id');
            $table->string('title', 30);
            $table->dateTime('start');
            $table->dateTime('end');
            $table->integer('product_id')->unsigned();
            $table->string('description');
            $table->boolean('status')->default(false);
            $table->integer('order')->default(1);
            $table->timestamps();
        });

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('amazings');
    }
}
