<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateProfitsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('profits', function (Blueprint $table) {
            $table->increments('id');
            $table->bigInteger('payment_id')->unsigned();
            $table->unsignedInteger('sell');
            $table->Integer('discount_sell');
            $table->unsignedInteger('buy');
            $table->unsignedInteger('qty');
            $table->integer('single_profit');
            $table->integer('gross_profit');
            $table->integer('p_gross_profit');
            $table->integer('p_gross_margin');
            $table->foreign('payment_id' )->references('id')->on('payments')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('profits');
    }
}
