<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateReviewsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('reviews', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('user_id')->unsigned();
            $table->integer('product_id')->unsigned();
            $table->string('name');
            $table->text('text');
            $table->tinyInteger('confirmed')->default(0);
            $table->unsignedTinyInteger('product_score')->nullable();
                        $table->integer('replay_id')->nullable();
            $table->foreign('user_id' )->references('id')->on('users')->onDelete('cascade');
            $table->foreign('product_id' )->references('id')->on('products')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('reviews');
    }
}
