<?php

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreatePaymentsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('payments', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('cart_id')->unsigned();
            $table->integer('transaction_id')->unsigned()->nullable();
            $table->unsignedInteger('package_price');
            $table->unsignedInteger('shipment_price');
            $table->unsignedInteger('total');
            $table->integer('discount_code_id')->unsigned()->nullable();
            $table->integer('discount')->default(0);
            $table->unsignedInteger('payable_price');
            $table->smallInteger('paid')->default(0);
            $table->unsignedTinyInteger('status')->default(0);
            $table->foreign('cart_id' )->references('id')->on('carts')->onDelete('cascade');
            $table->foreign('transaction_id' )->references('id')->on('gateway_transactions_logs')->onDelete('cascade');
            $table->foreign('discount_code_id' )->references('id')->on('discount_codes');
            $table->timestamps();
        });

        DB::update("ALTER TABLE payments AUTO_INCREMENT = 10000000;");
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('payments');
    }
}
