<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateDiscountCodesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('discount_codes', function (Blueprint $table) {
            $table->increments('id');
            $table->string('code',100)->unique();
            $table->smallInteger('discount_type')->default(10);
            $table->tinyInteger('percentage')->nullable();
            $table->unsignedInteger('amount')->nullable();
            $table->timestamp('valid_time')->nullable();
            $table->unsignedMediumInteger('times_left')->nullable();
            $table->unsignedInteger('price_down')->nullable();
            $table->unsignedInteger('price_top')->nullable();
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('discount_codes');
    }
}
