<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCartProductsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('cart_products', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('cart_id')->unsigned();
            $table->integer('product_color_id')->unsigned();
            $table->unsignedMediumInteger('qty');
            $table->unsignedInteger('base_sell_price');
            $table->unsignedInteger('discount_sell_price')->nullable();
            $table->integer('discount')->nullable();
            $table->integer('total')->nullable();
//            $table->unsignedTinyInteger('multi_seller')->default(0);
            $table->date('sell_date')->nullable();
            $table->timestamps();
            $table->softDeletes();
            $table->foreign('cart_id' )->references('id')->on('carts')->onDelete('cascade');
            $table->foreign('product_color_id' )->references('id')->on('products_color')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('cart_products');
    }
}
